/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.jboss.seam.security.EntityAction;
import org.jboss.seam.security.EntityPermissionChecker;

public class EntitySecurityListener {
    @PostLoad
    public void postLoad(Object entity) {
        EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.READ);
    }

    @PrePersist
    public void prePersist(Object entity) {
        EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.INSERT);
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.UPDATE);
    }

    @PreRemove
    public void preRemove(Object entity) {
        EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.DELETE);
    }
}

