/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.Filter;
import org.jboss.seam.persistence.PersistenceContextManager;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@BypassInterceptors
@Install(value=false)
public class ManagedPersistenceContext
implements Serializable,
HttpSessionActivationListener,
Mutable,
PersistenceContextManager,
Synchronization {
    private static final long serialVersionUID = -4972387440275848126L;
    private static final LogProvider log = Logging.getLogProvider(ManagedPersistenceContext.class);
    private transient EntityManager entityManager;
    private String persistenceUnitJndiName;
    private String componentName;
    private Expressions.ValueExpression<EntityManagerFactory> entityManagerFactory;
    private List<Filter> filters = new ArrayList<Filter>(0);
    private transient boolean synchronizationRegistered;
    private transient boolean destroyed;

    @Override
    public boolean clearDirty() {
        return true;
    }

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.persistenceUnitJndiName == null) {
            this.persistenceUnitJndiName = "java:/" + this.componentName;
        }
        PersistenceContexts.instance().touch(this.componentName);
    }

    private void initEntityManager() {
        this.entityManager = this.getEntityManagerFactoryFromJndiOrValueBinding().createEntityManager();
        PersistenceProvider persistenceProvider = PersistenceProvider.instance();
        this.entityManager = persistenceProvider.proxyEntityManager(this.entityManager);
        this.setEntityManagerFlushMode(PersistenceContexts.instance().getFlushMode());
        for (Filter f : this.filters) {
            if (!f.isFilterEnabled()) continue;
            persistenceProvider.enableFilter(f, this.entityManager);
        }
        if (log.isDebugEnabled()) {
            if (this.entityManagerFactory == null) {
                log.debug("created seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName);
            } else {
                log.debug("created seam managed persistence context from EntityManagerFactory");
            }
        }
    }

    @Unwrap
    public EntityManager getEntityManager() throws NamingException, SystemException {
        if (this.entityManager == null) {
            this.initEntityManager();
        }
        if (!this.synchronizationRegistered && !Lifecycle.isDestroying()) {
            this.joinTransaction();
        }
        return this.entityManager;
    }

    private void joinTransaction() throws SystemException {
        UserTransaction transaction = Transaction.instance();
        if (transaction.isActive()) {
            transaction.enlist(this.entityManager);
            try {
                transaction.registerSynchronization(this);
                this.synchronizationRegistered = true;
            }
            catch (Exception e) {
                this.synchronizationRegistered = PersistenceProvider.instance().registerSynchronization(this, this.entityManager);
            }
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.synchronizationRegistered) {
            throw new IllegalStateException("cannot passivate persistence context with active transaction");
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    @Destroy
    public void destroy() {
        this.destroyed = true;
        if (!this.synchronizationRegistered) {
            this.close();
        }
        PersistenceContexts.instance().untouch(this.componentName);
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
        if (this.destroyed) {
            this.close();
        }
    }

    public void beforeCompletion() {
    }

    private void close() {
        if (Contexts.isEventContextActive()) {
            boolean transactionActive = false;
            try {
                UserTransaction tx = Transaction.instance();
                try {
                    transactionActive = tx.isActive();
                }
                catch (SystemException se) {
                    log.debug("could not get transaction status while destroying persistence context");
                }
            }
            catch (Exception e) {
                log.warn("could not get transaction while destroying persistence context. (called during session expiration ?)");
            }
            if (transactionActive) {
                throw new IllegalStateException("attempting to destroy the persistence context while an active transaction exists (try installing <transaction:ejb-transaction/>)");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("destroying seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName);
        }
        if (this.entityManager != null && this.entityManager.isOpen()) {
            this.entityManager.close();
        }
    }

    public EntityManagerFactory getEntityManagerFactoryFromJndiOrValueBinding() {
        EntityManagerFactory result = null;
        if (this.entityManagerFactory != null) {
            result = this.entityManagerFactory.getValue();
        }
        if (result == null) {
            try {
                result = (EntityManagerFactory)Naming.getInitialContext().lookup(this.persistenceUnitJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("EntityManagerFactory not found in JNDI : " + this.persistenceUnitJndiName, ne);
            }
        }
        return result;
    }

    public Expressions.ValueExpression<EntityManagerFactory> getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(Expressions.ValueExpression<EntityManagerFactory> entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public String getPersistenceUnitJndiName() {
        return this.persistenceUnitJndiName;
    }

    public void setPersistenceUnitJndiName(String persistenceUnitName) {
        this.persistenceUnitJndiName = persistenceUnitName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public void changeFlushMode(FlushModeType flushMode) {
        if (this.entityManager != null && this.entityManager.isOpen()) {
            this.setEntityManagerFlushMode(flushMode);
        }
    }

    protected void setEntityManagerFlushMode(FlushModeType flushMode) {
        switch (flushMode) {
            case AUTO: {
                this.entityManager.setFlushMode(javax.persistence.FlushModeType.AUTO);
                break;
            }
            case COMMIT: {
                this.entityManager.setFlushMode(javax.persistence.FlushModeType.COMMIT);
                break;
            }
            case MANUAL: {
                PersistenceProvider.instance().setFlushModeManual(this.entityManager);
            }
        }
    }

    public String toString() {
        return "ManagedPersistenceContext(" + this.persistenceUnitJndiName + ")";
    }
}

