/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.lang.reflect.Method;
import org.jboss.seam.Component;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousExceptionHandler;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;

public class AsynchronousInvocation
extends Asynchronous {
    static final long serialVersionUID = 7426196491669891310L;
    private static transient LogProvider log = Logging.getLogProvider(AsynchronousInvocation.class);
    private String methodName;
    private Class[] argTypes;
    private Object[] args;
    private String componentName;

    public AsynchronousInvocation(Method method, String componentName, Object[] args) {
        this.methodName = method.getName();
        this.argTypes = method.getParameterTypes();
        this.args = args == null ? new Object[]{} : args;
        this.componentName = componentName;
    }

    public AsynchronousInvocation(InvocationContext invocation, Component component) {
        this(invocation.getMethod(), component.getName(), invocation.getParameters());
    }

    public void execute(Object timer) {
        new Asynchronous.ContextualAsynchronousRequest(this, timer){

            protected void process() {
                Method method;
                Object target = Component.getInstance(AsynchronousInvocation.this.componentName);
                try {
                    method = target.getClass().getMethod(AsynchronousInvocation.this.methodName, AsynchronousInvocation.this.argTypes);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalStateException(nsme);
                }
                Reflections.invokeAndWrap(method, target, AsynchronousInvocation.this.args);
            }
        }.run();
    }

    public String toString() {
        return "AsynchronousInvocation(" + this.componentName + '.' + this.methodName + "())";
    }

    protected void handleException(final Exception exception, Object timer) {
        new Asynchronous.ContextualAsynchronousRequest(this, timer){

            protected void process() {
                Object target = Component.getInstance(AsynchronousInvocation.this.componentName);
                try {
                    Method method = target.getClass().getMethod("handleAsynchronousException", Exception.class);
                    log.trace("Using asynchronous exception handler " + AsynchronousInvocation.this.componentName + ".handleAsynchronsException;");
                    method.invoke(target, exception);
                }
                catch (Exception exception2) {
                    log.trace("Using default asynchronous exception handler");
                    AsynchronousExceptionHandler.instance().handleException(exception);
                }
            }
        }.run();
    }
}

