/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.bpm.Jbpm;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jbpm.JbpmContext;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.bpm.jbpmContext")
@BypassInterceptors
@Install(precedence=0, dependencies={"org.jboss.seam.bpm.jbpm"})
public class ManagedJbpmContext
implements Synchronization {
    private static final LogProvider log = Logging.getLogProvider(ManagedJbpmContext.class);
    private JbpmContext jbpmContext;
    private boolean synchronizationRegistered;

    @Create
    public void create() throws NamingException, RollbackException, SystemException {
        this.jbpmContext = Jbpm.instance().getJbpmConfiguration().createJbpmContext();
        this.assertNoTransactionManagement();
        log.debug("created seam managed jBPM context");
    }

    private void assertNoTransactionManagement() {
        DbPersistenceServiceFactory dpsf = (DbPersistenceServiceFactory)this.jbpmContext.getJbpmConfiguration().getServiceFactory("persistence");
        if (dpsf.isTransactionEnabled()) {
            throw new IllegalStateException("jBPM transaction management is enabled, disable in jbpm.cfg.xml");
        }
    }

    @Unwrap
    public JbpmContext getJbpmContext() throws NamingException, RollbackException, SystemException {
        this.joinTransaction();
        return this.jbpmContext;
    }

    private void joinTransaction() throws SystemException {
        UserTransaction transaction = Transaction.instance();
        if (!transaction.isActiveOrMarkedRollback()) {
            throw new IllegalStateException("JbpmContext may only be used inside a transaction");
        }
        if (!this.synchronizationRegistered && !Lifecycle.isDestroying() && transaction.isActive()) {
            this.jbpmContext.getSession().isOpen();
            try {
                transaction.registerSynchronization(this);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.jbpmContext.getSession().getTransaction().registerSynchronization((Synchronization)this);
            }
            this.synchronizationRegistered = true;
        }
    }

    public void beforeCompletion() {
        log.debug("flushing seam managed jBPM context");
        if (Contexts.isBusinessProcessContextActive()) {
            Contexts.getBusinessProcessContext().flush();
        }
        this.jbpmContext.getSession().flush();
        log.debug("done flushing seam managed jBPM context");
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
        if (!Contexts.isEventContextActive()) {
            this.closeContext();
        }
    }

    @Destroy
    public void destroy() {
        if (!this.synchronizationRegistered) {
            this.closeContext();
        }
    }

    private void closeContext() {
        log.debug("destroying seam managed jBPM context");
        this.jbpmContext.close();
        log.debug("done destroying seam managed jBPM context");
    }

    public static JbpmContext instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("no active event context");
        }
        return (JbpmContext)Component.getInstance(ManagedJbpmContext.class, ScopeType.EVENT);
    }
}

