/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.captcha;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Random;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.captcha.CaptchaResponse;
import org.jboss.seam.contexts.Contexts;

@Name(value="org.jboss.seam.captcha.captcha")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
public class Captcha
implements Serializable {
    private static Random random = new Random(System.currentTimeMillis());
    private String correctResponse;
    private String challenge;
    private String response;

    @Create
    public void init() {
        int x = random.nextInt(50);
        int y = random.nextInt(50);
        this.setCorrectResponse(Integer.toString(x + y));
        this.setChallenge(String.valueOf(Integer.toString(x)) + " + " + Integer.toString(y) + " =");
    }

    protected void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    protected String getChallenge() {
        return this.challenge;
    }

    protected void setCorrectResponse(String correctResponse) {
        this.correctResponse = correctResponse;
    }

    public boolean validateResponse(String response) {
        boolean valid;
        boolean bl = valid = response != null && this.correctResponse != null && response.trim().equals(this.correctResponse);
        if (!valid) {
            this.init();
        }
        return valid;
    }

    @CaptchaResponse
    public String getResponse() {
        return this.response;
    }

    public void setResponse(String input) {
        this.response = input;
    }

    public BufferedImage renderChallenge() {
        BufferedImage challenge = new BufferedImage(70, 20, 10);
        Graphics graphics = challenge.getGraphics();
        graphics.setColor(this.getChallengeBackgroundColor());
        graphics.fillRect(0, 0, this.getChallengeImageWidth(), 20);
        graphics.setColor(this.getChallengeTextColor());
        graphics.drawString(this.getChallenge(), 5, 15);
        return challenge;
    }

    protected int getChallengeImageWidth() {
        return 70;
    }

    protected Color getChallengeBackgroundColor() {
        return Color.WHITE;
    }

    protected Color getChallengeTextColor() {
        return Color.BLACK;
    }

    public static Captcha instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No session context active");
        }
        return (Captcha)Component.getInstance(Captcha.class, ScopeType.SESSION);
    }
}

