/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Locale;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;

@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Install(precedence=0)
@Name(value="org.jboss.seam.core.resourceLoader")
public class ResourceLoader {
    private static final LogProvider log = Logging.getLogProvider(ResourceLoader.class);
    private String[] bundleNames = new String[]{"messages"};

    public String[] getBundleNames() {
        return this.bundleNames;
    }

    public void setBundleNames(String[] bundleNames) {
        this.bundleNames = bundleNames;
    }

    public InputStream getResourceAsStream(String resource) {
        return Resources.getResourceAsStream(resource, ServletLifecycle.getCurrentServletContext());
    }

    public URL getResource(String resource) {
        return Resources.getResource(resource, ServletLifecycle.getCurrentServletContext());
    }

    public ResourceBundle loadBundle(String bundleName) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.instance(), Thread.currentThread().getContextClassLoader());
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(bundleName, Locale.instance(), ServletLifecycle.getCurrentServletContext().getClass().getClassLoader());
            }
            log.debug("loaded resource bundle: " + bundleName);
            return bundle;
        }
        catch (MissingResourceException missingResourceException) {
            log.debug("resource bundle missing: " + bundleName);
            return null;
        }
    }

    public String toString() {
        String concat = this.bundleNames == null ? "" : Strings.toString(", ", (Object[])this.bundleNames);
        return "ResourceBundle(" + concat + ")";
    }

    public static ResourceLoader instance() {
        if (!Contexts.isApplicationContextActive()) {
            return new ResourceLoader();
        }
        return (ResourceLoader)Component.getInstance(ResourceLoader.class, ScopeType.STATELESS);
    }
}

