/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.document;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class DocumentData
implements Serializable {
    DocumentType documentType;
    String baseName;
    String disposition = "inline";
    String fileName;

    public DocumentData(String baseName, DocumentType documentType) {
        this.documentType = documentType;
        this.baseName = baseName;
    }

    public abstract void writeDataToStream(OutputStream var1) throws IOException;

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        if (this.fileName == null) {
            return String.valueOf(this.getBaseName()) + "." + this.getDocumentType().getExtension();
        }
        return this.fileName;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public static class DocumentType
    implements Serializable {
        private String mimeType;
        private String extension;

        public DocumentType(String extension, String mimeType) {
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

