/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Query;
import org.jboss.seam.persistence.QueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateEntityQuery<E>
extends Query<Session, E> {
    private List<E> resultList;
    private E singleResult;
    private Long resultCount;
    private Boolean cacheable;
    private String cacheRegion;
    private Integer fetchSize;

    @Override
    public void validate() {
        super.validate();
        if (this.getSession() == null) {
            throw new IllegalStateException("hibernateSession is null");
        }
    }

    @Override
    @Transactional
    public List<E> getResultList() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initResultList();
        return this.truncResultList(this.resultList);
    }

    private void initResultList() {
        if (this.resultList == null) {
            org.hibernate.Query query = this.createQuery();
            this.resultList = query == null ? null : query.list();
        }
    }

    @Override
    @Transactional
    public boolean isNextExists() {
        return this.resultList != null && this.getMaxResults() != null && this.resultList.size() > this.getMaxResults();
    }

    @Override
    @Transactional
    public E getSingleResult() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initSingleResult();
        return this.singleResult;
    }

    private void initSingleResult() {
        if (this.singleResult == null) {
            org.hibernate.Query query = this.createQuery();
            this.singleResult = query == null ? null : query.uniqueResult();
        }
    }

    @Override
    @Transactional
    public Long getResultCount() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initResultCount();
        return this.resultCount;
    }

    private void initResultCount() {
        if (this.resultCount == null) {
            org.hibernate.Query query = this.createCountQuery();
            this.resultCount = query == null ? null : (Long)query.uniqueResult();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.resultCount = null;
        this.resultList = null;
        this.singleResult = null;
    }

    public Session getSession() {
        return (Session)this.getPersistenceContext();
    }

    public void setSession(Session session) {
        this.setPersistenceContext(session);
    }

    @Override
    protected String getPersistenceContextName() {
        return "hibernateSession";
    }

    protected org.hibernate.Query createQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        org.hibernate.Query query = this.getSession().createQuery(this.getRenderedEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        if (this.getFirstResult() != null) {
            query.setFirstResult(this.getFirstResult().intValue());
        }
        if (this.getMaxResults() != null) {
            query.setMaxResults(this.getMaxResults() + 1);
        }
        if (this.getCacheable() != null) {
            query.setCacheable(this.getCacheable().booleanValue());
        }
        if (this.getCacheRegion() != null) {
            query.setCacheRegion(this.getCacheRegion());
        }
        if (this.getFetchSize() != null) {
            query.setFetchSize(this.getFetchSize().intValue());
        }
        return query;
    }

    protected org.hibernate.Query createCountQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        org.hibernate.Query query = this.getSession().createQuery(this.getCountEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        return query;
    }

    private void setParameters(org.hibernate.Query query, List<Object> parameters, int start) {
        int i = 0;
        while (i < parameters.size()) {
            Object parameterValue = parameters.get(i);
            if (this.isRestrictionParameterSet(parameterValue)) {
                if (parameterValue instanceof Collection) {
                    query.setParameterList(QueryParser.getParameterName(start + i), (Collection)parameterValue);
                } else {
                    query.setParameter(QueryParser.getParameterName(start + i), parameterValue);
                }
            }
            ++i;
        }
    }

    protected Boolean getCacheable() {
        return this.cacheable;
    }

    protected void setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
    }

    protected String getCacheRegion() {
        return this.cacheRegion;
    }

    protected void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    protected Integer getFetchSize() {
        return this.fetchSize;
    }

    protected void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }
}

