/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.model.DataModel;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.faces.Validation;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Action;
import org.jboss.seam.navigation.ConversationControl;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Header;
import org.jboss.seam.navigation.Input;
import org.jboss.seam.navigation.NaturalConversationIdParameter;
import org.jboss.seam.navigation.Navigation;
import org.jboss.seam.navigation.Output;
import org.jboss.seam.navigation.Page;
import org.jboss.seam.navigation.Param;
import org.jboss.seam.navigation.ProcessControl;
import org.jboss.seam.navigation.RedirectNavigationHandler;
import org.jboss.seam.navigation.RenderNavigationHandler;
import org.jboss.seam.navigation.Rule;
import org.jboss.seam.navigation.SafeActions;
import org.jboss.seam.navigation.TaskControl;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;
import org.jboss.seam.web.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Name(value="org.jboss.seam.navigation.pages")
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@Startup
public class Pages {
    private static final LogProvider log = Logging.getLogProvider(Pages.class);
    private Expressions.ValueExpression<String> noConversationViewId;
    private String loginViewId;
    private Integer httpPort;
    private Integer httpsPort;
    private Map<String, Page> pagesByViewId;
    private Map<String, List<Page>> pageStacksByViewId;
    private Map<String, ConversationIdParameter> conversations;
    private String[] resources = new String[]{"/WEB-INF/pages.xml"};
    private SortedSet<String> wildcardViewIds = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String x, String y) {
            if (x.length() < y.length()) {
                return -1;
            }
            if (x.length() > y.length()) {
                return 1;
            }
            return x.compareTo(y);
        }
    });

    @Create
    public void create() {
        if (DotPageDotXmlDeploymentHandler.instance() != null) {
            this.initialize(DotPageDotXmlDeploymentHandler.instance().getResources());
        } else {
            this.initialize();
        }
    }

    public void initialize() {
        this.initialize(null);
    }

    public void initialize(Set<FileDescriptor> fileNames) {
        this.pagesByViewId = Collections.synchronizedMap(new HashMap());
        this.pageStacksByViewId = Collections.synchronizedMap(new HashMap());
        this.conversations = Collections.synchronizedMap(new HashMap());
        String[] stringArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            InputStream stream = ResourceLoader.instance().getResourceAsStream(resource);
            if (stream == null) {
                log.debug("no pages.xml file found: " + resource);
            } else {
                log.debug("reading pages.xml file: " + resource);
                try {
                    this.parse(stream);
                }
                finally {
                    Resources.closeStream(stream);
                }
            }
            ++n2;
        }
        if (fileNames != null) {
            this.parsePages(fileNames);
        }
    }

    private void parsePages(Set<FileDescriptor> files) {
        for (FileDescriptor file : files) {
            String fileName = file.getName();
            String viewId = "/" + fileName.substring(0, fileName.length() - ".page.xml".length()) + ".xhtml";
            InputStream stream = null;
            try {
                stream = file.getUrl().openStream();
            }
            catch (IOException iOException) {}
            if (stream == null) continue;
            log.debug("reading pages.xml file: " + fileName);
            try {
                this.parse(stream, viewId);
            }
            finally {
                Resources.closeStream(stream);
            }
        }
    }

    public boolean navigate(FacesContext context, String actionExpression, String actionOutcomeValue) {
        String viewId = Pages.getViewId(context);
        if (viewId != null) {
            List<Page> stack = this.getPageStack(viewId);
            int i = stack.size() - 1;
            while (i >= 0) {
                Page page = stack.get(i);
                Navigation navigation = page.getNavigations().get(actionExpression);
                if (navigation == null) {
                    navigation = page.getDefaultNavigation();
                }
                if (navigation != null && navigation.navigate(context, actionOutcomeValue)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    public Page getPage(String viewId) {
        if (viewId == null) {
            return new Page(viewId);
        }
        Page result = this.getCachedPage(viewId);
        if (result == null) {
            return this.createPage(viewId);
        }
        return result;
    }

    private Page createPage(String viewId) {
        Page result = new Page(viewId);
        this.pagesByViewId.put(viewId, result);
        return result;
    }

    private Page getCachedPage(String viewId) {
        return this.pagesByViewId.get(viewId);
    }

    protected List<Page> getPageStack(String viewId) {
        List<Page> stack = this.pageStacksByViewId.get(viewId);
        if (stack == null) {
            stack = this.createPageStack(viewId);
            this.pageStacksByViewId.put(viewId, stack);
        }
        return stack;
    }

    private List<Page> createPageStack(String viewId) {
        Page page;
        ArrayList<Page> stack = new ArrayList<Page>(1);
        if (viewId != null && !Pages.isDebugPage(viewId)) {
            for (String wildcard : this.wildcardViewIds) {
                if (!viewId.startsWith(wildcard.substring(0, wildcard.length() - 1))) continue;
                stack.add(this.getPage(wildcard));
            }
        }
        if ((page = this.getPage(viewId)) != null) {
            stack.add(page);
        }
        return stack;
    }

    public boolean preRender(FacesContext facesContext) {
        String scheme;
        String viewId = Pages.getViewId(facesContext);
        String requestScheme = this.getRequestScheme(facesContext);
        if (requestScheme != null && (scheme = this.getScheme(viewId)) != null && !requestScheme.equals(scheme)) {
            Manager.instance().redirect(viewId);
            return false;
        }
        this.selectDataModelRow(facesContext);
        List<Page> pageStack = this.getPageStack(viewId);
        for (Page page : pageStack) {
            if (this.isNoConversationRedirectRequired(page)) {
                this.redirectToNoConversationView();
                return false;
            }
            if (!this.isLoginRedirectRequired(viewId, page)) continue;
            this.redirectToLoginView();
            return false;
        }
        boolean result = Pages.callAction(facesContext);
        if (!facesContext.getResponseComplete()) {
            String newViewId = Pages.getViewId(facesContext);
            for (Page page : this.getPageStack(newViewId)) {
                if (this.isNoConversationRedirectRequired(page)) {
                    this.redirectToNoConversationView();
                    return false;
                }
                if (!this.isLoginRedirectRequired(newViewId, page)) continue;
                this.redirectToLoginView();
                return false;
            }
            for (Page page : this.getPageStack(newViewId)) {
                boolean bl = result = page.preRender(facesContext) || result;
            }
        }
        return result;
    }

    protected void selectDataModelRow(FacesContext facesContext) {
        String dataModelSelection = (String)facesContext.getExternalContext().getRequestParameterMap().get("dataModelSelection");
        if (dataModelSelection != null) {
            int colonLoc = dataModelSelection.indexOf(58);
            int bracketLoc = dataModelSelection.indexOf(91);
            if (colonLoc > 0 && bracketLoc > colonLoc) {
                String var = dataModelSelection.substring(0, colonLoc);
                String name = dataModelSelection.substring(colonLoc + 1, bracketLoc);
                int index = Integer.parseInt(dataModelSelection.substring(bracketLoc + 1, dataModelSelection.length() - 1));
                Object value = Component.getInstance(name, true);
                if (value != null) {
                    DataModel dataModel = (DataModel)value;
                    if (index < dataModel.getRowCount()) {
                        dataModel.setRowIndex(index);
                        Contexts.getEventContext().set(var, dataModel.getRowData());
                    } else {
                        log.debug("DataModel row was unavailable");
                        Contexts.getEventContext().remove(var);
                    }
                }
            }
        }
    }

    public void postRestore(FacesContext facesContext) {
        this.storeRequestStringValuesInPageContext(facesContext);
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            if (this.isLoginRedirectRequired(viewId, page)) {
                this.redirectToLoginView();
                return;
            }
            if (this.isNoConversationRedirectRequired(page)) {
                this.redirectToNoConversationView();
                return;
            }
            if (facesContext.getRenderResponse()) continue;
            page.postRestore(facesContext);
        }
        if (this.convertAndValidateStringValuesInPageContext(facesContext)) {
            Validation.instance().fail();
        } else {
            this.applyConvertedValidatedValuesToModel(facesContext);
        }
    }

    public boolean isLoginRedirectRequired(FacesContext facesContext) {
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            if (!this.isLoginRedirectRequired(viewId, page)) continue;
            return true;
        }
        return false;
    }

    private boolean isNoConversationRedirectRequired(Page page) {
        return page.isConversationRequired() && !Manager.instance().isLongRunningOrNestedConversation();
    }

    private boolean isLoginRedirectRequired(String viewId, Page page) {
        return page.isLoginRequired() && !viewId.equals(this.getLoginViewId()) && !Identity.instance().isLoggedIn();
    }

    public String getRequestScheme(FacesContext facesContext) {
        String requestUrl = Pages.getRequestUrl(facesContext);
        if (requestUrl == null) {
            return null;
        }
        int idx = requestUrl.indexOf(58);
        return idx < 0 ? null : requestUrl.substring(0, idx);
    }

    public String encodeScheme(String viewId, FacesContext context, String url) {
        String requestUrl;
        String scheme = this.getScheme(viewId);
        if (scheme != null && (requestUrl = Pages.getRequestUrl(context)) != null) {
            try {
                URL serverUrl = new URL(requestUrl);
                StringBuilder sb = new StringBuilder();
                sb.append(scheme);
                sb.append("://");
                sb.append(serverUrl.getHost());
                if ("http".equals(scheme) && this.httpPort != null) {
                    sb.append(":");
                    sb.append(this.httpPort);
                } else if ("https".equals(scheme) && this.httpsPort != null) {
                    sb.append(":");
                    sb.append(this.httpsPort);
                } else if (serverUrl.getPort() != -1) {
                    sb.append(":");
                    sb.append(serverUrl.getPort());
                }
                if (!url.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(url);
                url = sb.toString();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return url;
    }

    private static String getRequestUrl(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getRequestURL().toString();
        }
        return null;
    }

    public void redirectToLoginView() {
        this.notLoggedIn();
        String loginViewId = this.getLoginViewId();
        if (loginViewId == null) {
            throw new NotLoggedInException();
        }
        Manager.instance().redirect(loginViewId);
    }

    public void redirectToNoConversationView() {
        this.noConversation();
        FacesPage facesPage = FacesPage.instance();
        String pageflowName = facesPage.getPageflowName();
        String pageflowNodeName = facesPage.getPageflowNodeName();
        String noConversationViewId = null;
        if (pageflowName == null || pageflowNodeName == null) {
            String viewId = Pages.getCurrentViewId();
            noConversationViewId = this.getNoConversationViewId(viewId);
        } else {
            noConversationViewId = Pageflow.instance().getNoConversationViewId(pageflowName, pageflowNodeName);
        }
        if (noConversationViewId != null) {
            Manager.instance().redirect(noConversationViewId);
        }
    }

    public String getScheme(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            Page page = stack.get(i);
            if (page.getScheme() != null) {
                return page.getScheme();
            }
            --i;
        }
        return null;
    }

    public boolean hasDescription(String viewId) {
        return this.getDescription(viewId) != null;
    }

    public String getDescription(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            Page page = stack.get(i);
            if (page.hasDescription()) {
                return page.getDescription();
            }
            --i;
        }
        return null;
    }

    public String renderDescription(String viewId) {
        return Interpolator.instance().interpolate(this.getDescription(viewId), new Object[0]);
    }

    protected void noConversation() {
        Events.instance().raiseEvent("org.jboss.seam.noConversation", new Object[0]);
        FacesMessages.instance().addFromResourceBundleOrDefault(StatusMessage.Severity.WARN, "org.jboss.seam.NoConversation", "The conversation ended, timed out or was processing another request", new Object[0]);
    }

    protected void notLoggedIn() {
        Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
        Events.instance().raiseEvent("org.jboss.seam.security.notLoggedIn", new Object[0]);
    }

    public static String toString(Object returnValue) {
        return returnValue == null ? null : returnValue.toString();
    }

    public static void handleOutcome(FacesContext facesContext, String outcome, String fromAction) {
        facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        Contexts.getPageContext().flush();
    }

    public static Pages instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Pages)Component.getInstance(Pages.class, ScopeType.APPLICATION);
    }

    private static boolean callAction(FacesContext facesContext) {
        String outcome;
        boolean result = false;
        String fromAction = outcome = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionOutcome");
        String decodedOutcome = null;
        if (outcome != null) {
            decodedOutcome = URLDecoder.decode(outcome);
        }
        if (decodedOutcome != null && (decodedOutcome.indexOf(35) >= 0 || decodedOutcome.indexOf(123) >= 0)) {
            throw new IllegalArgumentException("EL expressions are not allowed in actionOutcome parameter");
        }
        if (outcome == null) {
            String actionId = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionMethod");
            if (actionId != null) {
                String decodedActionId = URLDecoder.decode(actionId);
                if (decodedActionId != null && (decodedActionId.indexOf(35) >= 0 || decodedActionId.indexOf(123) >= 0)) {
                    throw new IllegalArgumentException("EL expressions are not allowed in actionMethod parameter");
                }
                if (!SafeActions.instance().isActionSafe(actionId)) {
                    return result;
                }
                String expression = SafeActions.toAction(actionId);
                result = true;
                Expressions.MethodExpression<Object> actionExpression = Expressions.instance().createMethodExpression(expression);
                outcome = Pages.toString(actionExpression.invoke(new Object[0]));
                fromAction = expression;
                Pages.handleOutcome(facesContext, outcome, fromAction);
            }
        } else {
            Pages.handleOutcome(facesContext, outcome, fromAction);
        }
        return result;
    }

    public List<ResourceBundle> getResourceBundles(String viewId) {
        ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>(1);
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            Page page = stack.get(i);
            ResourceBundle bundle = page.getResourceBundle();
            if (bundle != null) {
                result.add(bundle);
            }
            --i;
        }
        return result;
    }

    public Map<String, Object> getStringValuesFromModel(FacesContext facesContext, String viewId, Set<String> overridden) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                if (overridden.contains(pageParameter.getName())) continue;
                String value = null;
                if (pageParameter.getValueExpression() == null) {
                    if (Contexts.isPageContextActive()) {
                        value = (String)Contexts.getPageContext().get(pageParameter.getName());
                    }
                } else {
                    value = pageParameter.getStringValueFromModel(facesContext);
                }
                if (value == null) continue;
                parameters.put(pageParameter.getName(), value);
            }
        }
        return parameters;
    }

    private void storeRequestStringValuesInPageContext(FacesContext facesContext) {
        Parameters parameters = Parameters.instance();
        if (parameters != null) {
            Map<String, String[]> requestParameters = parameters.getRequestParameters();
            for (Page page : this.getPageStack(Pages.getViewId(facesContext))) {
                for (Param pageParameter : page.getParameters()) {
                    String value = pageParameter.getStringValueFromRequest(facesContext, requestParameters);
                    if (value == null) {
                        if (!facesContext.getRenderResponse()) continue;
                        Contexts.getPageContext().remove(pageParameter.getName());
                        continue;
                    }
                    Contexts.getPageContext().set(pageParameter.getName(), value);
                }
            }
        }
    }

    private boolean convertAndValidateStringValuesInPageContext(FacesContext facesContext) {
        boolean validationFailed = false;
        for (Page page : this.getPageStack(Pages.getViewId(facesContext))) {
            for (Param pageParameter : page.getParameters()) {
                try {
                    String value = (String)Contexts.getPageContext().get(pageParameter.getName());
                    if (value == null) continue;
                    Object convertedValue = pageParameter.convertValueFromString(facesContext, value);
                    pageParameter.validateConvertedValue(facesContext, convertedValue);
                    Contexts.getEventContext().set(pageParameter.getName(), convertedValue);
                }
                catch (ValidatorException ve) {
                    if (ve.getFacesMessage() != null) {
                        facesContext.addMessage(null, ve.getFacesMessage());
                    }
                    validationFailed = true;
                }
                catch (ConverterException ce) {
                    if (ce.getFacesMessage() != null) {
                        facesContext.addMessage(null, ce.getFacesMessage());
                    }
                    validationFailed = true;
                }
            }
        }
        return validationFailed;
    }

    private void applyConvertedValidatedValuesToModel(FacesContext facesContext) {
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object object;
                Expressions.ValueExpression valueExpression = pageParameter.getValueExpression();
                if (valueExpression == null || (object = Contexts.getEventContext().get(pageParameter.getName())) == null) continue;
                valueExpression.setValue(object);
            }
        }
    }

    public Map<String, Object> getStringValuesFromPageContext(FacesContext facesContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object object = Contexts.getPageContext().get(pageParameter.getName());
                if (object == null) continue;
                parameters.put(pageParameter.getName(), object);
            }
        }
        return parameters;
    }

    public void updateStringValuesInPageContextUsingModel(FacesContext facesContext) {
        for (Page page : this.getPageStack(Pages.getViewId(facesContext))) {
            for (Param pageParameter : page.getParameters()) {
                if (pageParameter.getValueExpression() == null) continue;
                String value = pageParameter.getStringValueFromModel(facesContext);
                if (value == null) {
                    Contexts.getPageContext().remove(pageParameter.getName());
                    continue;
                }
                Contexts.getPageContext().set(pageParameter.getName(), value);
            }
        }
    }

    public String encodePageParameters(FacesContext facesContext, String url, String viewId) {
        return this.encodePageParameters(facesContext, url, viewId, Collections.EMPTY_SET);
    }

    public String encodePageParameters(FacesContext facesContext, String url, String viewId, Set<String> overridden) {
        Map<String, Object> parameters = this.getStringValuesFromModel(facesContext, viewId, overridden);
        return Manager.instance().encodeParameters(url, parameters);
    }

    public String getNoConversationViewId(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            String noConversationViewId;
            Page page = stack.get(i);
            if (page.getNoConversationViewId() != null && (noConversationViewId = page.getNoConversationViewId().getValue()) != null) {
                return noConversationViewId;
            }
            --i;
        }
        return this.noConversationViewId != null ? this.noConversationViewId.getValue() : null;
    }

    public Integer getTimeout(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            Page page = stack.get(i);
            Integer timeout = page.getTimeout();
            if (timeout != null) {
                return timeout;
            }
            --i;
        }
        return Manager.instance().getConversationTimeout();
    }

    public Integer getConcurrentRequestTimeout(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        int i = stack.size() - 1;
        while (i >= 0) {
            Page page = stack.get(i);
            Integer concurrentRequestTimeout = page.getConcurrentRequestTimeout();
            if (concurrentRequestTimeout != null) {
                return concurrentRequestTimeout;
            }
            --i;
        }
        return Manager.instance().getConcurrentRequestTimeout();
    }

    public static String getSuffix() {
        String defaultSuffix = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        return defaultSuffix == null ? ".jsp" : defaultSuffix;
    }

    private void parse(InputStream stream) {
        String value;
        String noConversationViewIdString;
        Element root = Pages.getDocumentRoot(stream);
        if (this.noConversationViewId == null && (noConversationViewIdString = root.attributeValue("no-conversation-view-id")) != null) {
            this.noConversationViewId = Expressions.instance().createValueExpression(noConversationViewIdString, String.class);
        }
        if (this.loginViewId == null) {
            this.loginViewId = root.attributeValue("login-view-id");
        }
        if (this.httpPort == null) {
            try {
                value = root.attributeValue("http-port");
                if (!Strings.isEmpty(value)) {
                    this.httpPort = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid value specified for http-port attribute in pages.xml");
            }
        }
        if (this.httpsPort == null) {
            try {
                value = root.attributeValue("https-port");
                if (!Strings.isEmpty(value)) {
                    this.httpsPort = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid valid specified for https-port attribute in pages.xml");
            }
        }
        List elements = root.elements("conversation");
        for (Element conversation : elements) {
            this.parseConversation(conversation, conversation.attributeValue("name"));
        }
        elements = root.elements("page");
        for (Element page : elements) {
            this.parse(page, page.attributeValue("view-id"));
        }
    }

    private void parse(InputStream stream, String viewId) {
        this.parse(Pages.getDocumentRoot(stream), viewId);
    }

    private static Element getDocumentRoot(InputStream stream) {
        try {
            return XML.getRootElement(stream);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }

    private void parseConversation(Element element, String name) {
        if (name == null) {
            throw new IllegalStateException("Must specify name for <conversation/> declaration");
        }
        if (this.conversations.containsKey(name)) {
            throw new IllegalStateException("<conversation/> declaration already exists for [" + name + "]");
        }
        NaturalConversationIdParameter param = new NaturalConversationIdParameter(name, element.attributeValue("parameter-name"), element.attributeValue("parameter-value"));
        this.conversations.put(name, param);
    }

    private void parse(Element element, String viewId) {
        if (viewId == null) {
            throw new IllegalStateException("Must specify view-id for <page/> declaration");
        }
        if (viewId.endsWith("*")) {
            this.wildcardViewIds.add(viewId);
        }
        Page page = new Page(viewId);
        this.pagesByViewId.put(viewId, page);
        this.parsePage(page, element, viewId);
        Pages.parseConversationControl(element, page.getConversationControl());
        Pages.parseTaskControl(element, page.getTaskControl());
        Pages.parseProcessControl(element, page.getProcessControl());
        List children = element.elements("param");
        for (Element param : children) {
            page.getParameters().add(Pages.parseParam(param, page.isValidateModel()));
        }
        List moreChildren = element.elements("navigation");
        for (Element fromAction : moreChildren) {
            Pages.parseActionNavigation(page, fromAction);
        }
        Element restrict = element.element("restrict");
        if (restrict != null) {
            page.setRestricted(true);
            String expr = restrict.getTextTrim();
            if (!Strings.isEmpty(expr)) {
                page.setRestriction(expr);
            }
        }
        List headers = element.elements("header");
        for (Element header : headers) {
            page.getHeaders().add(Pages.parseHeader(header));
        }
    }

    public ConversationIdParameter getConversationIdParameter(String conversationName) {
        return this.conversations.get(conversationName);
    }

    private Page parsePage(Page page, Element element, String viewId) {
        ConversationIdParameter param;
        String noConversationViewIdString;
        String concurrentRequestTimeoutString;
        String timeoutString;
        String description;
        page.setSwitchEnabled(!"disabled".equals(element.attributeValue("switch")));
        Element optionalElement = element.element("description");
        String string = description = optionalElement == null ? element.getTextTrim() : optionalElement.getTextTrim();
        if (description != null && description.length() > 0) {
            page.setDescription(description);
        }
        if ((timeoutString = element.attributeValue("timeout")) != null) {
            page.setTimeout(Integer.parseInt(timeoutString));
        }
        if ((concurrentRequestTimeoutString = element.attributeValue("concurrent-request-timeout")) != null) {
            page.setConcurrentRequestTimeout(Integer.parseInt(concurrentRequestTimeoutString));
        }
        if ((noConversationViewIdString = element.attributeValue("no-conversation-view-id")) != null) {
            page.setNoConversationViewId(Expressions.instance().createValueExpression(noConversationViewIdString, String.class));
        }
        page.setConversationRequired(Boolean.parseBoolean(element.attributeValue("conversation-required")));
        page.setLoginRequired(Boolean.parseBoolean(element.attributeValue("login-required")));
        page.setScheme(element.attributeValue("scheme"));
        String expiresValue = element.attributeValue("expires");
        if (expiresValue != null) {
            page.setExpires(Integer.parseInt(expiresValue));
        }
        if ((param = this.conversations.get(element.attributeValue("conversation"))) != null) {
            page.setConversationIdParameter(param);
        }
        List patterns = element.elements("rewrite");
        for (Element pattern : patterns) {
            page.addRewritePattern(pattern.attributeValue("pattern"));
        }
        List events = element.elements("raise-event");
        for (Element eventElement : events) {
            page.addEventType(eventElement.attributeValue("type"));
        }
        Action action = Pages.parseAction(element, "action", false);
        if (action != null) {
            page.getActions().add(action);
        }
        List childElements = element.elements("action");
        for (Element childElement : childElements) {
            page.getActions().add(Pages.parseAction(childElement, "execute", true));
        }
        String bundle = element.attributeValue("bundle");
        if (bundle != null) {
            page.setResourceBundleName(bundle);
        }
        List moreChildElements = element.elements("in");
        for (Element child : moreChildElements) {
            Input input = new Input();
            input.setName(child.attributeValue("name"));
            input.setValue(Expressions.instance().createValueExpression(child.attributeValue("value")));
            String scopeName = child.attributeValue("scope");
            if (scopeName != null) {
                input.setScope(ScopeType.valueOf(scopeName.toUpperCase()));
            }
            page.getInputs().add(input);
        }
        String validateModelStr = element.attributeValue("validate-model");
        if (validateModelStr != null) {
            page.setValidateModel(Boolean.parseBoolean(validateModelStr));
        }
        return page;
    }

    private static Action parseAction(Element element, String actionAtt, boolean conditionalsAllowed) {
        Action action = new Action();
        String methodExpression = element.attributeValue(actionAtt);
        if (methodExpression == null) {
            return null;
        }
        if (methodExpression.startsWith("#{")) {
            action.setMethodExpression(Expressions.instance().createMethodExpression(methodExpression));
        } else {
            action.setOutcome(methodExpression);
        }
        if (conditionalsAllowed) {
            String expression = element.attributeValue("if");
            if (expression != null) {
                action.setValueExpression(Expressions.instance().createValueExpression(expression));
            }
            action.setOnPostback(!"false".equals(element.attributeValue("on-postback")));
        }
        return action;
    }

    private static void parseConversationControl(Element element, ConversationControl control) {
        Element beginConversation;
        Element endConversation = element.element("end-conversation");
        Element element2 = endConversation = endConversation == null ? element.element("end-task") : endConversation;
        if (endConversation != null) {
            control.setEndConversation(true);
            control.setEndConversationBeforeRedirect(Boolean.parseBoolean(endConversation.attributeValue("before-redirect")));
            control.setEndRootConversation(Boolean.parseBoolean(endConversation.attributeValue("root")));
            String expression = endConversation.attributeValue("if");
            if (expression != null) {
                control.setEndConversationCondition(Expressions.instance().createValueExpression(expression, Boolean.class));
            }
        }
        beginConversation = (beginConversation = element.element("begin-conversation")) == null ? element.element("begin-task") : beginConversation;
        Element element3 = beginConversation = beginConversation == null ? element.element("start-task") : beginConversation;
        if (beginConversation != null) {
            String expression;
            control.setBeginConversation(true);
            control.setJoin(Boolean.parseBoolean(beginConversation.attributeValue("join")));
            control.setNested(Boolean.parseBoolean(beginConversation.attributeValue("nested")));
            control.setPageflow(beginConversation.attributeValue("pageflow"));
            control.setConversationName(beginConversation.attributeValue("conversation"));
            String flushMode = beginConversation.attributeValue("flush-mode");
            if (flushMode != null) {
                control.setFlushMode(FlushModeType.valueOf(flushMode.toUpperCase()));
            }
            if ((expression = beginConversation.attributeValue("if")) != null) {
                control.setBeginConversationCondition(Expressions.instance().createValueExpression(expression, Boolean.class));
            }
        }
        if (control.isBeginConversation() && control.isEndConversation()) {
            throw new IllegalStateException("cannot use both <begin-conversation/> and <end-conversation/>");
        }
    }

    private static void parseTaskControl(Element element, TaskControl control) {
        Element startTask;
        Element beginTask;
        Element endTask = element.element("end-task");
        if (endTask != null) {
            control.setEndTask(true);
            String transition = endTask.attributeValue("transition");
            if (transition != null) {
                control.setTransition(Expressions.instance().createValueExpression(transition, String.class));
            }
        }
        if ((beginTask = element.element("begin-task")) != null) {
            control.setBeginTask(true);
            String taskId = beginTask.attributeValue("task-id");
            if (taskId == null) {
                taskId = "#{param.taskId}";
            }
            control.setTaskId(Expressions.instance().createValueExpression(taskId, Long.class));
        }
        if ((startTask = element.element("start-task")) != null) {
            control.setStartTask(true);
            String taskId = startTask.attributeValue("task-id");
            if (taskId == null) {
                taskId = "#{param.taskId}";
            }
            control.setTaskId(Expressions.instance().createValueExpression(taskId, Long.class));
        }
        if (control.isBeginTask() && control.isEndTask()) {
            throw new IllegalStateException("cannot use both <begin-task/> and <end-task/>");
        }
        if (control.isBeginTask() && control.isStartTask()) {
            throw new IllegalStateException("cannot use both <start-task/> and <begin-task/>");
        }
        if (control.isStartTask() && control.isEndTask()) {
            throw new IllegalStateException("cannot use both <start-task/> and <end-task/>");
        }
    }

    private static void parseProcessControl(Element element, ProcessControl control) {
        Element resumeProcess;
        Element createProcess = element.element("create-process");
        if (createProcess != null) {
            control.setCreateProcess(true);
            control.setDefinition(createProcess.attributeValue("definition"));
        }
        if ((resumeProcess = element.element("resume-process")) != null) {
            control.setResumeProcess(true);
            String processId = resumeProcess.attributeValue("process-id");
            if (processId == null) {
                processId = "#{param.processId}";
            }
            control.setProcessId(Expressions.instance().createValueExpression(processId, Long.class));
        }
        if (control.isCreateProcess() && control.isResumeProcess()) {
            throw new IllegalStateException("cannot use both <create-process/> and <resume-process/>");
        }
    }

    private static void parseEvent(Element element, Rule rule) {
        List events = element.elements("raise-event");
        for (Element eventElement : events) {
            rule.addEventType(eventElement.attributeValue("type"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseActionNavigation(Page entry, Element element) {
        Navigation navigation = new Navigation();
        String outcomeExpression = element.attributeValue("evaluate");
        if (outcomeExpression != null) {
            navigation.setOutcome(Expressions.instance().createValueExpression(outcomeExpression));
        }
        List cases = element.elements("rule");
        for (Element childElement : cases) {
            navigation.getRules().add(Pages.parseRule(childElement));
        }
        Rule rule = new Rule();
        Pages.parseEvent(element, rule);
        Pages.parseNavigationHandler(element, rule);
        Pages.parseConversationControl(element, rule.getConversationControl());
        Pages.parseTaskControl(element, rule.getTaskControl());
        Pages.parseProcessControl(element, rule.getProcessControl());
        navigation.setRule(rule);
        String expression = element.attributeValue("from-action");
        if (expression == null) {
            if (entry.getDefaultNavigation() != null) throw new IllegalStateException("multiple catchall <navigation> elements");
            entry.setDefaultNavigation(navigation);
            return;
        } else {
            Navigation old = entry.getNavigations().put(expression, navigation);
            if (old == null) return;
            throw new IllegalStateException("multiple <navigation> elements for action: " + expression);
        }
    }

    private static Param parseParam(Element element, boolean validateModel) {
        String valueExpression = element.attributeValue("value");
        String name = element.attributeValue("name");
        if (name == null) {
            if (valueExpression == null) {
                throw new IllegalArgumentException("must specify name or value for page <param/> declaration");
            }
            name = valueExpression.substring(2, valueExpression.length() - 1);
        }
        Param param = new Param(name, validateModel);
        if (valueExpression != null) {
            param.setValueExpression(Expressions.instance().createValueExpression(valueExpression));
        }
        param.setConverterId(element.attributeValue("converterId"));
        String converterExpression = element.attributeValue("converter");
        if (converterExpression != null) {
            param.setConverterValueExpression(Expressions.instance().createValueExpression(converterExpression));
        }
        param.setValidatorId(element.attributeValue("validatorId"));
        String validatorExpression = element.attributeValue("validator");
        if (validatorExpression != null) {
            param.setValidatorValueExpression(Expressions.instance().createValueExpression(validatorExpression));
        }
        param.setRequired(Boolean.parseBoolean(element.attributeValue("required")));
        String validateModelStr = element.attributeValue("validateModel");
        if (validateModelStr != null) {
            param.setValidateModel(Boolean.parseBoolean(validateModelStr));
        }
        return param;
    }

    private static Header parseHeader(Element element) {
        Header header = new Header();
        String name = element.attributeValue("name");
        header.setName(name);
        String valueExpression = element.attributeValue("value");
        if (valueExpression == null) {
            valueExpression = element.getTextTrim();
        }
        header.setValue(Expressions.instance().createValueExpression(valueExpression));
        return header;
    }

    private static Rule parseRule(Element element) {
        Rule rule = new Rule();
        rule.setOutcomeValue(element.attributeValue("if-outcome"));
        String expression = element.attributeValue("if");
        if (expression != null) {
            rule.setCondition(Expressions.instance().createValueExpression(expression));
        }
        Pages.parseConversationControl(element, rule.getConversationControl());
        Pages.parseTaskControl(element, rule.getTaskControl());
        Pages.parseProcessControl(element, rule.getProcessControl());
        Pages.parseEvent(element, rule);
        Pages.parseNavigationHandler(element, rule);
        return rule;
    }

    private static void parseNavigationHandler(Element element, Rule rule) {
        Element redirect;
        Element render = element.element("render");
        if (render != null) {
            String viewId = render.attributeValue("view-id");
            Element messageElement = render.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String control = messageElement == null ? null : messageElement.attributeValue("for");
            Iterator severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(((String)((Object)severityName)).toUpperCase());
            rule.addNavigationHandler(new RenderNavigationHandler(Pages.stringValueExpressionFor(viewId), message, severity, control));
        }
        if ((redirect = element.element("redirect")) != null) {
            List children = redirect.elements("param");
            ArrayList<Param> params = new ArrayList<Param>();
            for (Element child : children) {
                params.add(Pages.parseParam(child, true));
            }
            String viewId = redirect.attributeValue("view-id");
            String url = redirect.attributeValue("url");
            String includePageParamsAttr = redirect.attributeValue("include-page-params");
            boolean includePageParams = includePageParamsAttr == null ? true : Boolean.getBoolean(includePageParamsAttr);
            Element messageElement = redirect.element("message");
            String control = messageElement == null ? null : messageElement.attributeValue("for");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(severityName.toUpperCase());
            rule.addNavigationHandler(new RedirectNavigationHandler(Pages.stringValueExpressionFor(viewId), Pages.stringValueExpressionFor(url), params, message, severity, control, includePageParams));
        }
        List childElements = element.elements("out");
        for (Element child : childElements) {
            Output output = new Output();
            output.setName(child.attributeValue("name"));
            output.setValue(Expressions.instance().createValueExpression(child.attributeValue("value")));
            String scopeName = child.attributeValue("scope");
            if (scopeName == null) {
                output.setScope(ScopeType.CONVERSATION);
            } else {
                output.setScope(ScopeType.valueOf(scopeName.toUpperCase()));
            }
            rule.getOutputs().add(output);
        }
    }

    private static Expressions.ValueExpression<String> stringValueExpressionFor(String expr) {
        return (Expressions.ValueExpression)(expr == null ? expr : (Serializable)Expressions.instance().createValueExpression(expr, String.class));
    }

    public static Map<String, FacesMessage.Severity> getFacesMessageValuesMap() {
        HashMap<String, FacesMessage.Severity> result = new HashMap<String, FacesMessage.Severity>();
        for (Map.Entry me : FacesMessage.VALUES_MAP.entrySet()) {
            result.put(((String)me.getKey()).toUpperCase(), (FacesMessage.Severity)me.getValue());
        }
        return result;
    }

    public Expressions.ValueExpression<String> getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setNoConversationViewId(Expressions.ValueExpression<String> noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String getLoginViewId() {
        return this.loginViewId;
    }

    public void setLoginViewId(String loginViewId) {
        this.loginViewId = loginViewId;
    }

    public static String getCurrentViewId() {
        return Pages.getViewId(FacesContext.getCurrentInstance());
    }

    public static String getCurrentBaseName() {
        String viewId = Pages.getViewId(FacesContext.getCurrentInstance());
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public static String getViewId(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null) {
            return viewRoot.getViewId();
        }
        return null;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    private static boolean isDebugPage(String viewId) {
        return Init.instance().isDebugPageAvailable() && viewId.startsWith("/debug.");
    }

    public static boolean isDebugPage() {
        return Init.instance().isDebugPageAvailable() && Pages.getCurrentViewId() != null && Pages.getCurrentViewId().startsWith("/debug.");
    }

    public Collection<String> getKnownViewIds() {
        return this.pagesByViewId.keySet();
    }
}

