/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.action;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.security.management.IdentityManager;

@Name(value="org.jboss.seam.security.management.roleSearch")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
public class RoleSearch
implements Serializable {
    @DataModel
    List<String> roles;
    @DataModelSelection
    String selectedRole;
    @In
    IdentityManager identityManager;

    public void loadRoles() {
        this.roles = this.identityManager.listRoles();
    }

    public String getRoleGroups(String role) {
        List<String> roles = this.identityManager.getRoleGroups(role);
        if (roles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String r : roles) {
            sb.append(String.valueOf(sb.length() > 0 ? ", " : "") + r);
        }
        return sb.toString();
    }

    public String getSelectedRole() {
        return this.selectedRole;
    }
}

