/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.action;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.security.management.IdentityManager;

@Name(value="org.jboss.seam.security.management.userSearch")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
public class UserSearch
implements Serializable {
    private static final long serialVersionUID = 8592034786339372510L;
    @DataModel
    List<String> users;
    @DataModelSelection
    String selectedUser;
    @In
    IdentityManager identityManager;

    public void loadUsers() {
        this.users = this.identityManager.listUsers();
    }

    public String getUserRoles(String username) {
        List<String> roles = this.identityManager.getGrantedRoles(username);
        if (roles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            sb.append(String.valueOf(sb.length() > 0 ? ", " : "") + role);
        }
        return sb.toString();
    }

    public String getSelectedUser() {
        return this.selectedUser;
    }
}

