/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.servlet.ServletApplicationMap;
import org.jboss.seam.util.SortItem;
import org.jboss.seam.util.Sorter;
import org.jboss.seam.web.AbstractFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamFilter
implements javax.servlet.Filter {
    private static final LogProvider log = Logging.getLogProvider(SeamFilter.class);
    private List<javax.servlet.Filter> filters;

    public void init(FilterConfig filterConfig) throws ServletException {
        Lifecycle.setupApplication(new ServletApplicationMap(filterConfig.getServletContext()));
        try {
            this.filters = this.getSortedFilters();
            for (javax.servlet.Filter filter : this.filters) {
                log.info("Initializing filter: " + Component.getComponentName(filter.getClass()));
                filter.init(filterConfig);
            }
        }
        finally {
            Lifecycle.cleanupApplication();
        }
    }

    private List<javax.servlet.Filter> getSortedFilters() {
        HashMap<String, SortItem<javax.servlet.Filter>> sortItemsMap = new HashMap<String, SortItem<javax.servlet.Filter>>();
        List sortItems = new ArrayList();
        for (String string : Init.instance().getInstalledFilters()) {
            javax.servlet.Filter filter = (javax.servlet.Filter)Component.getInstance(string, ScopeType.APPLICATION);
            boolean disabled = false;
            if (filter instanceof AbstractFilter) {
                disabled = ((AbstractFilter)filter).isDisabled();
            }
            if (disabled) continue;
            SortItem<javax.servlet.Filter> si = new SortItem<javax.servlet.Filter>(filter);
            sortItemsMap.put(string, si);
            sortItems.add(si);
        }
        for (SortItem sortItem : sortItems) {
            Filter filterAnn = this.getFilterAnnotation(((javax.servlet.Filter)sortItem.getObj()).getClass());
            if (filterAnn == null) continue;
            for (String s : Arrays.asList(filterAnn.around())) {
                SortItem aroundSortItem = (SortItem)sortItemsMap.get(s);
                if (sortItem == null || aroundSortItem == null) continue;
                sortItem.getAround().add(aroundSortItem);
            }
            for (String s : Arrays.asList(filterAnn.within())) {
                SortItem withinSortItem = (SortItem)sortItemsMap.get(s);
                if (sortItem == null || withinSortItem == null) continue;
                sortItem.getWithin().add(withinSortItem);
            }
        }
        Sorter sorter = new Sorter();
        sortItems = sorter.sort(sortItems);
        ArrayList<javax.servlet.Filter> sorted = new ArrayList<javax.servlet.Filter>();
        for (SortItem si : sortItems) {
            sorted.add((javax.servlet.Filter)si.getObj());
        }
        return sorted;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        new FilterChainImpl(chain).doFilter(request, response);
    }

    public void destroy() {
        for (javax.servlet.Filter filter : this.filters) {
            filter.destroy();
        }
    }

    private Filter getFilterAnnotation(Class<?> clazz) {
        while (!Object.class.equals(clazz)) {
            if (clazz.isAnnotationPresent(Filter.class)) {
                return clazz.getAnnotation(Filter.class);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private class FilterChainImpl
    implements FilterChain {
        private FilterChain chain;
        private int index;

        private FilterChainImpl(FilterChain chain) {
            this.chain = chain;
            this.index = -1;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (++this.index < SeamFilter.this.filters.size()) {
                javax.servlet.Filter filter = (javax.servlet.Filter)SeamFilter.this.filters.get(this.index);
                if (filter instanceof AbstractFilter) {
                    AbstractFilter bf = (AbstractFilter)filter;
                    if (bf.isMappedToCurrentRequestPath(request)) {
                        filter.doFilter(request, response, (FilterChain)this);
                    } else {
                        this.doFilter(request, response);
                    }
                } else {
                    filter.doFilter(request, response, (FilterChain)this);
                }
            } else {
                this.chain.doFilter(request, response);
            }
        }
    }
}

