/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.theme;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.theme.ThemeSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Name(value="org.jboss.seam.theme.themeFactory")
@Install(precedence=0)
public class Theme {
    protected Map<String, String> createMap() {
        final ResourceBundle bundle = ThemeSelector.instance().getThemeResourceBundle();
        if (bundle == null) {
            return null;
        }
        return new AbstractMap<String, String>(){

            @Override
            public String get(Object key) {
                if (key instanceof String) {
                    String resource;
                    String resourceKey = (String)key;
                    try {
                        resource = bundle.getString(resourceKey);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return resourceKey;
                    }
                    if (resource == null) {
                        return resourceKey;
                    }
                    return Interpolator.instance().interpolate(resource, new Object[0]);
                }
                return null;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                HashSet<Map.Entry<String, String>> entrySet = new HashSet<Map.Entry<String, String>>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    final String key = keys.nextElement();
                    entrySet.add(new Map.Entry<String, String>(){

                        @Override
                        public String getKey() {
                            return key;
                        }

                        @Override
                        public String getValue() {
                            return this.get(key);
                        }

                        @Override
                        public String setValue(String arg0) {
                            throw new UnsupportedOperationException("not implemented");
                        }
                    });
                }
                return entrySet;
            }
        };
    }

    @Factory(value="org.jboss.seam.theme.theme", autoCreate=true, scope=ScopeType.EVENT)
    public Map getTheme() {
        return this.createMap();
    }

    public static Map instance() {
        return (Map)Component.getInstance("org.jboss.seam.theme.theme", true);
    }
}

