/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedBeanProperty {
    private Field propertyField;
    private Method propertyGetter;
    private Method propertySetter;
    private String name;
    private boolean isFieldProperty;
    private boolean set = false;

    public TypedBeanProperty(Class<?> cls, Class type) {
        Field f;
        AccessibleObject[] accessibleObjectArray = cls.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = accessibleObjectArray[n2];
            if (f.getGenericType().equals(type)) {
                this.setupFieldProperty(f);
                this.set = true;
                return;
            }
            ++n2;
        }
        accessibleObjectArray = cls.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            f = accessibleObjectArray[n2];
            if (f.getGenericType().equals(type)) {
                this.setupFieldProperty(f);
                this.set = true;
                return;
            }
            ++n2;
        }
        accessibleObjectArray = cls.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject m = accessibleObjectArray[n2];
            if (((Method)m).getGenericReturnType().equals(type)) {
                String methodName = ((Method)m).getName();
                if (((Method)m).getName().startsWith("get")) {
                    this.name = Introspector.decapitalize(((Method)m).getName().substring(3));
                } else if (methodName.startsWith("is")) {
                    this.name = Introspector.decapitalize(((Method)m).getName().substring(2));
                }
                if (this.name != null) {
                    this.propertyGetter = Reflections.getGetterMethod(cls, this.name);
                    this.propertySetter = Reflections.getSetterMethod(cls, this.name);
                    this.isFieldProperty = false;
                    this.set = true;
                } else {
                    throw new IllegalStateException("Invalid accessor method, must start with 'get' or 'is'.  Method: " + m + " in class: " + cls);
                }
            }
            ++n2;
        }
    }

    private void setupFieldProperty(Field propertyField) {
        this.propertyField = propertyField;
        this.isFieldProperty = true;
        this.name = propertyField.getName();
    }

    public void setValue(Object bean, Object value) {
        if (this.isFieldProperty) {
            Reflections.setAndWrap(this.propertyField, bean, value);
        } else {
            Reflections.invokeAndWrap(this.propertySetter, bean, value);
        }
    }

    public Object getValue(Object bean) {
        if (this.isFieldProperty) {
            return Reflections.getAndWrap(this.propertyField, bean);
        }
        return Reflections.invokeAndWrap(this.propertyGetter, bean, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSet() {
        return this.set;
    }
}

