/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;
import org.jboss.seam.web.AbstractResource;

public abstract class ConditionalAbstractResource
extends AbstractResource {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final LogProvider log = Logging.getLogProvider(ConditionalAbstractResource.class);

    public boolean sendConditional(HttpServletRequest request, HttpServletResponse response, String entityTag, Long lastModified) throws IOException {
        String noneMatchHeader = request.getHeader(HEADER_IF_NONE_MATCH);
        Long modifiedSinceHeader = request.getDateHeader(HEADER_IF_MODIFIED_SINCE);
        boolean noneMatchValid = false;
        if (entityTag != null) {
            if (!(entityTag.startsWith("\"") || entityTag.startsWith("W/\"") || entityTag.endsWith("\""))) {
                throw new IllegalArgumentException("Entity tag is not properly formatted (or quoted): " + entityTag);
            }
            response.setHeader(HEADER_ETAG, entityTag);
            if (noneMatchHeader != null) {
                noneMatchValid = this.isNoneMatchConditionValid(noneMatchHeader, entityTag);
            }
        }
        boolean modifiedSinceValid = false;
        if (lastModified != null) {
            response.setDateHeader(HEADER_LAST_MODIFIED, lastModified.longValue());
            if (modifiedSinceHeader != -1L) {
                modifiedSinceValid = this.isModifiedSinceConditionValid(modifiedSinceHeader, lastModified);
            }
        }
        if (noneMatchHeader != null && modifiedSinceHeader != -1L) {
            log.debug("If-None-Match and If-Modified-Since must match");
            if (noneMatchValid && modifiedSinceValid) {
                log.debug("If-None-Match and If-Modified-Since conditions match, sending 304");
                response.sendError(304);
                return true;
            }
            log.debug("If-None-Match and If-Modified-Since conditions do not match, not sending 304");
            return false;
        }
        if (noneMatchHeader != null && noneMatchValid) {
            log.debug("If-None-Match condition matches, sending 304");
            response.sendError(304);
            return true;
        }
        if (modifiedSinceHeader != -1L && modifiedSinceValid) {
            log.debug("If-Modified-Since condition matches, sending 304");
            response.sendError(304);
            return true;
        }
        log.debug("None of the cache conditions match, not sending 304");
        return false;
    }

    protected boolean isNoneMatchConditionValid(String noneMatchHeader, String entityTag) {
        String[] entityTagsArray;
        if (noneMatchHeader.trim().equals("*")) {
            log.debug("Found * conditional request, hence current entity tag matches");
            return true;
        }
        String[] stringArray = entityTagsArray = noneMatchHeader.trim().split(",");
        int n = entityTagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String requestTag = stringArray[n2];
            if (requestTag.trim().equals(entityTag)) {
                log.debug("Found matching entity tag in request");
                return true;
            }
            ++n2;
        }
        log.debug("Resource has different entity tag than requested");
        return false;
    }

    protected boolean isModifiedSinceConditionValid(Long modifiedSinceHeader, Long lastModified) {
        if (lastModified <= modifiedSinceHeader) {
            log.debug("Resource has not been modified since requested timestamp");
            return true;
        }
        log.debug("Resource has been modified since requested timestamp");
        return false;
    }

    protected Long getLastModifiedTimestamp(String resourcePath) {
        try {
            URL resourceURL = Resources.getResource(resourcePath, this.getServletContext());
            if (resourceURL == null) {
                return ManagementFactory.getRuntimeMXBean().getStartTime();
            }
            URLConnection resourceConn = resourceURL.openConnection();
            return resourceConn.getLastModified();
        }
        catch (Exception exception) {
            return ManagementFactory.getRuntimeMXBean().getStartTime();
        }
    }

    protected String createEntityTag(String hashSource, boolean weak) {
        if (hashSource == null) {
            return null;
        }
        return String.valueOf(weak ? "W/\"" : "\"") + this.hash(hashSource, "UTF-8", "MD5") + "\"";
    }

    protected String createEntityTag(byte[] hashSource, boolean weak) {
        if (hashSource == null) {
            return null;
        }
        return String.valueOf(weak ? "W/\"" : "\"") + this.hash(hashSource, "MD5") + "\"";
    }

    protected String hash(String text, String charset, String algorithm) {
        try {
            return this.hash(text.getBytes(charset), algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String hash(byte[] bytes, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bytes);
            BigInteger number = new BigInteger(1, md.digest());
            StringBuffer sb = new StringBuffer("0");
            sb.append(number.toString(16));
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

