/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.seam.web.Rewrite;
import org.jboss.seam.web.ServletMapping;

public class IncomingPattern {
    String view;
    String pattern;
    ServletMapping viewMapping;
    Pattern regexp;
    List<String> regexpArgs = new ArrayList<String>();

    public IncomingPattern(ServletMapping viewMapping, String view, String pattern) {
        this.view = view;
        this.pattern = pattern;
        this.viewMapping = viewMapping;
        this.parsePattern(pattern);
    }

    public Rewrite rewrite(String path) {
        return new IncomingRewrite(path);
    }

    public void parsePattern(String value) {
        StringBuffer expr = new StringBuffer();
        expr.append("^");
        while (value.length() > 0) {
            int pos = value.indexOf(123);
            if (pos == -1) {
                expr.append(this.regexpLiteral(value));
                value = "";
                continue;
            }
            int pos2 = value.indexOf(125);
            if (pos2 == -1) {
                throw new IllegalArgumentException("invalid pattern");
            }
            expr.append(this.regexpLiteral(value.substring(0, pos)));
            String arg = value.substring(pos + 1, pos2);
            expr.append(this.regexpArg(arg));
            this.regexpArgs.add(arg);
            value = value.substring(pos2 + 1);
        }
        expr.append("$");
        this.regexp = Pattern.compile(expr.toString());
    }

    private String regexpArg(String substring) {
        return "([^/]*)";
    }

    private String regexpLiteral(String value) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                res.append(c);
            } else {
                res.append('\\').append(c);
            }
            ++i;
        }
        return res.toString();
    }

    private String mappedURL(String viewId) {
        return this.viewMapping.mapViewIdToURL(viewId);
    }

    public class IncomingRewrite
    implements Rewrite {
        String incoming;
        String queryArgs;
        Boolean isMatch = null;
        private List<String> matchedArgs = new ArrayList<String>();

        public IncomingRewrite(String incoming) {
            int queryPos = incoming.indexOf(63);
            if (queryPos == -1) {
                this.incoming = incoming;
                this.queryArgs = "";
            } else {
                this.incoming = incoming.substring(0, queryPos);
                this.queryArgs = incoming.substring(queryPos + 1);
            }
        }

        public boolean isMatch() {
            if (this.isMatch == null) {
                this.isMatch = this.match();
            }
            return this.isMatch;
        }

        protected boolean match() {
            if (this.incoming == null) {
                return false;
            }
            Matcher matcher = IncomingPattern.this.regexp.matcher(this.incoming);
            if (matcher.find()) {
                int i = 0;
                while (i < IncomingPattern.this.regexpArgs.size()) {
                    this.matchedArgs.add(matcher.group(i + 1));
                    ++i;
                }
                return true;
            }
            return false;
        }

        public String rewrite() {
            StringBuffer result = new StringBuffer();
            result.append(IncomingPattern.this.mappedURL(IncomingPattern.this.view));
            boolean first = true;
            if (this.queryArgs.length() > 0) {
                result.append('?').append(this.queryArgs);
                first = false;
            }
            int i = 0;
            while (i < IncomingPattern.this.regexpArgs.size()) {
                String key = IncomingPattern.this.regexpArgs.get(i);
                String value = this.matchedArgs.get(i);
                if (first) {
                    result.append('?');
                    first = false;
                } else {
                    result.append('&');
                }
                result.append(key).append('=').append(value);
                ++i;
            }
            return result.toString();
        }
    }
}

