/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.web.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contexts {
    private static final LogProvider log = Logging.getLogProvider(Contexts.class);
    static final ThreadLocal<Context> applicationContext = new ThreadLocal();
    static final ThreadLocal<Context> methodContext = new ThreadLocal();
    static final ThreadLocal<Context> eventContext = new ThreadLocal();
    static final ThreadLocal<Context> pageContext = new ThreadLocal();
    static final ThreadLocal<Context> sessionContext = new ThreadLocal();
    static final ThreadLocal<Context> conversationContext = new ThreadLocal();
    static final ThreadLocal<Context> businessProcessContext = new ThreadLocal();

    public static Context getEventContext() {
        return eventContext.get();
    }

    public static Context getMethodContext() {
        return methodContext.get();
    }

    public static Context getPageContext() {
        return pageContext.get();
    }

    public static Context getSessionContext() {
        return sessionContext.get();
    }

    public static Context getApplicationContext() {
        return applicationContext.get();
    }

    public static Context getConversationContext() {
        return conversationContext.get();
    }

    public static Context getBusinessProcessContext() {
        return businessProcessContext.get();
    }

    public static boolean isConversationContextActive() {
        return Contexts.getConversationContext() != null;
    }

    public static boolean isEventContextActive() {
        return eventContext.get() != null;
    }

    public static boolean isMethodContextActive() {
        return methodContext.get() != null;
    }

    public static boolean isPageContextActive() {
        if (pageContext.get() == null) {
            log.debug("isPageContextActive is null");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext != null && FacesLifecycle.getPhaseId() == PhaseId.RESTORE_VIEW) {
                log.debug("Page Context will be lazilly created");
                FacesLifecycle.resumePage();
                Map parameters = facesContext.getExternalContext().getRequestParameterMap();
                ConversationPropagation.instance().restoreConversationId(parameters);
                boolean conversationFound = Manager.instance().restoreConversation();
                pageContext.get().set("org.jboss.seam.jsf.SeamPhaseListener.conversationFound", conversationFound);
                FacesLifecycle.resumeConversation(facesContext.getExternalContext());
            }
        }
        return pageContext.get() != null;
    }

    public static boolean isSessionContextActive() {
        return sessionContext.get() != null;
    }

    public static boolean isApplicationContextActive() {
        return applicationContext.get() != null;
    }

    public static boolean isBusinessProcessContextActive() {
        return businessProcessContext.get() != null;
    }

    public static void removeFromAllContexts(String name) {
        log.debug("removing from all contexts: " + name);
        if (Contexts.isMethodContextActive()) {
            Contexts.getMethodContext().remove(name);
        }
        if (Contexts.isEventContextActive()) {
            Contexts.getEventContext().remove(name);
        }
        if (Contexts.isPageContextActive()) {
            Contexts.getPageContext().remove(name);
        }
        if (Contexts.isConversationContextActive()) {
            Contexts.getConversationContext().remove(name);
        }
        if (Contexts.isSessionContextActive()) {
            Contexts.getSessionContext().remove(name);
        }
        if (Contexts.isBusinessProcessContextActive()) {
            Contexts.getBusinessProcessContext().remove(name);
        }
        if (Contexts.isApplicationContextActive()) {
            Contexts.getApplicationContext().remove(name);
        }
    }

    public static Object lookupInStatefulContexts(String name) {
        Object result;
        if (Contexts.isMethodContextActive() && (result = Contexts.getMethodContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in method context: " + name);
            }
            return result;
        }
        if (Contexts.isEventContextActive() && (result = Contexts.getEventContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in event context: " + name);
            }
            return result;
        }
        if (Contexts.isPageContextActive() && (result = Contexts.getPageContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in page context: " + name);
            }
            return result;
        }
        if (Contexts.isConversationContextActive() && (result = Contexts.getConversationContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in conversation context: " + name);
            }
            return result;
        }
        if (Contexts.isSessionContextActive() && (result = Contexts.getSessionContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in session context: " + name);
            }
            return result;
        }
        if (Contexts.isBusinessProcessContextActive() && (result = Contexts.getBusinessProcessContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in business process context: " + name);
            }
            return result;
        }
        if (Contexts.isApplicationContextActive() && (result = Contexts.getApplicationContext().get(name)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("found in application context: " + name);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy(Context context) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preDestroyContext." + context.getType().toString(), new Object[0]);
        }
        Lifecycle.startDestroying();
        try {
            for (String name : context.getNames()) {
                Object object;
                Component component = Component.forName(name);
                log.debug("destroying: " + name);
                if (component == null || (object = context.get(name)) == null) continue;
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.preDestroy." + name, new Object[0]);
                }
                component.destroy(object);
            }
        }
        finally {
            Lifecycle.stopDestroying();
        }
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postDestroyContext." + context.getType().toString(), new Object[0]);
        }
    }

    static void startup(ScopeType scopeType) {
        Context context = Contexts.getApplicationContext();
        for (String name : context.getNames()) {
            Component component;
            Object object = context.get(name);
            if (object == null || !(object instanceof Component) || !(component = (Component)object).isStartup() || component.getScope() != scopeType) continue;
            Contexts.startup(component);
        }
    }

    static void startup(Component component) {
        if (component.isStartup()) {
            for (String dependency : component.getDependencies()) {
                Component dependentComponent = Component.forName(dependency);
                if (dependentComponent == null) continue;
                Contexts.startup(dependentComponent);
            }
        }
        if (!component.getScope().getContext().isSet(component.getName())) {
            log.debug("starting up: " + component.getName());
            component.newInstance();
        }
    }

    static boolean isAttributeDirty(Object attribute) {
        return attribute instanceof Mutable && ((Mutable)attribute).clearDirty();
    }

    static void flushAndDestroyContexts() {
        if (Contexts.isConversationContextActive()) {
            if (Contexts.isBusinessProcessContextActive()) {
                boolean destroyBusinessProcessContext;
                boolean transactionActive = false;
                try {
                    transactionActive = Transaction.instance().isActive();
                }
                catch (Exception e) {
                    log.error("could not discover transaction status");
                }
                if (transactionActive) {
                    Contexts.getBusinessProcessContext().flush();
                }
                boolean bl = destroyBusinessProcessContext = !Init.instance().isJbpmInstalled() || !BusinessProcess.instance().hasActiveProcess();
                if (destroyBusinessProcessContext) {
                    log.debug("destroying business process context");
                    Contexts.destroy(Contexts.getBusinessProcessContext());
                }
            }
            if (!Manager.instance().isLongRunningConversation()) {
                log.debug("destroying conversation context");
                Contexts.destroy(Contexts.getConversationContext());
            }
            log.debug("flushing server-side conversation context");
            Contexts.getConversationContext().flush();
            if (Session.getInstance() != null) {
                Manager.instance().unlockConversation();
            }
        }
        if (Contexts.isSessionContextActive()) {
            log.debug("flushing session context");
            Contexts.getSessionContext().flush();
        }
        if (Contexts.isEventContextActive()) {
            log.debug("destroying event context");
            Contexts.destroy(Contexts.getEventContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyConversationContext(Map<String, Object> session, String conversationId) {
        Context current = Contexts.getConversationContext();
        ServerConversationContext temp = new ServerConversationContext(session, conversationId);
        conversationContext.set(temp);
        try {
            Contexts.destroy(temp);
            if (!Session.instance().isInvalid()) {
                temp.clear();
                temp.flush();
            }
        }
        finally {
            conversationContext.set(current);
        }
    }
}

