/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.faces.RedirectException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Page;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.manager")
@Install(precedence=10, classDependencies={"javax.faces.context.FacesContext"})
@BypassInterceptors
public class FacesManager
extends Manager {
    private static final LogProvider log = Logging.getLogProvider(FacesManager.class);
    private boolean controllingRedirect;

    public void beforeRedirect(String viewId) {
        ConversationIdParameter targetPage;
        ConversationIdParameter currentPage;
        this.beforeRedirect();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String currentViewId = Pages.getViewId(facesContext);
        if (viewId != null && currentViewId != null && FacesManager.isDifferentConversationId(currentPage = Pages.instance().getPage(currentViewId).getConversationIdParameter(), targetPage = Pages.instance().getPage(viewId).getConversationIdParameter())) {
            this.updateCurrentConversationId(targetPage.getConversationId());
        }
    }

    public void interpolateAndRedirect(String url) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        int loc = url.indexOf(63);
        if (loc > 0) {
            StringTokenizer tokens = new StringTokenizer(url.substring(loc), "?=&");
            while (tokens.hasMoreTokens()) {
                String name = tokens.nextToken();
                String value = Interpolator.instance().interpolate(tokens.nextToken(), new Object[0]);
                parameters.put(name, value);
            }
            url = url.substring(0, loc);
        }
        this.redirect(url, parameters, true, true);
    }

    @Override
    protected void storeConversationToViewRootIfNecessary() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (FacesLifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE || FacesLifecycle.getPhaseId() == PhaseId.RESTORE_VIEW)) {
            FacesPage.instance().storeConversation();
        }
    }

    @Override
    protected String generateInitialConversationId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = Pages.getViewId(facesContext);
        if (viewId != null) {
            return Pages.instance().getPage(viewId).getConversationIdParameter().getInitialConversationId(facesContext.getExternalContext().getRequestParameterMap());
        }
        return super.generateInitialConversationId();
    }

    public void redirectToExternalURL(String url) {
        try {
            FacesContext.getCurrentInstance().getExternalContext().redirect(url);
        }
        catch (IOException e) {
            throw new RedirectException(e);
        }
    }

    @Override
    public void redirect(String viewId) {
        this.redirect(viewId, null, true, true);
    }

    public void redirect(String viewId, Map<String, Object> parameters, boolean includeConversationId) {
        this.redirect(viewId, parameters, includeConversationId, true);
    }

    public void redirect(String viewId, Map<String, Object> parameters, boolean includeConversationId, boolean includePageParams) {
        if (viewId == null) {
            throw new RedirectException("cannot redirect to a null viewId");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        if (parameters != null) {
            url = this.encodeParameters(url, parameters);
        }
        if (includePageParams) {
            url = Pages.instance().encodePageParameters(FacesContext.getCurrentInstance(), url, viewId, parameters == null ? Collections.EMPTY_SET : parameters.keySet());
        }
        if (includeConversationId) {
            this.beforeRedirect(viewId);
            url = this.encodeConversationId(url, viewId);
        }
        this.redirect(viewId, context, url);
    }

    @Override
    public void redirect(String viewId, String conversationId) {
        if (viewId == null) {
            throw new RedirectException("cannot redirect to a null viewId");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        url = this.encodeConversationId(url, viewId, conversationId);
        this.redirect(viewId, context, url);
    }

    private void redirect(String viewId, FacesContext context, String url) {
        url = Pages.instance().encodeScheme(viewId, context, url);
        if (log.isDebugEnabled()) {
            log.debug("redirecting to: " + url);
        }
        ExternalContext externalContext = context.getExternalContext();
        this.controllingRedirect = true;
        try {
            Contexts.getEventContext().set("org.jboss.seam.core.Manager", "");
            externalContext.redirect(externalContext.encodeActionURL(url));
        }
        catch (IOException ioe) {
            throw new RedirectException(ioe);
        }
        finally {
            Contexts.getEventContext().remove("org.jboss.seam.core.Manager");
            this.controllingRedirect = false;
        }
        context.responseComplete();
    }

    public String appendConversationIdFromRedirectFilter(String url, String viewId) {
        boolean appendConversationId;
        boolean bl = appendConversationId = !this.controllingRedirect;
        if (appendConversationId) {
            this.beforeRedirect(viewId);
            url = this.encodeConversationId(url, viewId);
        }
        return url;
    }

    public void prepareBackswitch(FacesContext facesContext) {
        org.jboss.seam.pageflow.Page page;
        Conversation conversation = Conversation.instance();
        org.jboss.seam.pageflow.Page page2 = page = Manager.instance().isLongRunningConversation() && Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess() && Pageflow.instance().isStarted() ? Pageflow.instance().getPage() : null;
        if (page == null) {
            Pages pages = Pages.instance();
            if (pages != null) {
                String viewId = Pages.getViewId(facesContext);
                Page pageEntry = pages.getPage(viewId);
                if (pageEntry.isSwitchEnabled()) {
                    conversation.setViewId(viewId);
                }
                if (pageEntry.hasDescription()) {
                    conversation.setDescription(pageEntry.renderDescription());
                } else if (pages.hasDescription(viewId)) {
                    conversation.setDescription(pages.renderDescription(viewId));
                }
                conversation.setTimeout(pages.getTimeout(viewId));
                conversation.setConcurrentRequestTimeout(pages.getConcurrentRequestTimeout(viewId));
            }
        } else {
            if (page.isSwitchEnabled()) {
                conversation.setViewId(Pageflow.instance().getPageViewId());
            }
            if (page.hasDescription()) {
                conversation.setDescription(page.getDescription());
            }
            conversation.setTimeout(page.getTimeout());
        }
        this.flushConversationMetadata();
    }

    public static FacesManager instance() {
        return (FacesManager)Manager.instance();
    }
}

