/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.seam.ComponentType;
import org.jboss.seam.Instance;
import org.jboss.seam.InstantiationException;
import org.jboss.seam.Model;
import org.jboss.seam.Namespace;
import org.jboss.seam.RequiredException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.DataBinderClass;
import org.jboss.seam.annotations.DataSelectorClass;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.PerNestedConversation;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Synchronized;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.bpm.BeginTask;
import org.jboss.seam.annotations.bpm.EndTask;
import org.jboss.seam.annotations.bpm.StartTask;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.faces.Converter;
import org.jboss.seam.annotations.faces.Validator;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.annotations.intercept.Interceptors;
import org.jboss.seam.annotations.security.PermissionCheck;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.annotations.security.RoleCheck;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.databinding.DataBinder;
import org.jboss.seam.databinding.DataSelector;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.ClientSideInterceptor;
import org.jboss.seam.intercept.JavaBeanInterceptor;
import org.jboss.seam.intercept.Proxy;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.ProxyFactory;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.SortItem;
import org.jboss.seam.util.Sorter;
import org.jboss.seam.web.Parameters;

@Scope(value=ScopeType.APPLICATION)
public class Component
extends Model {
    public static final String PROPERTIES = "org.jboss.seam.properties";
    private static final LogProvider log = Logging.getLogProvider(Component.class);
    static ReentrantLock factoryLock = new ReentrantLock();
    private ComponentType type;
    private String name;
    private ScopeType scope;
    private String jndiName;
    private boolean interceptionEnabled;
    private boolean startup;
    private String[] dependencies;
    private boolean synchronize;
    private long timeout;
    private boolean secure;
    private Set<Class> businessInterfaces;
    private Method destroyMethod;
    private Method createMethod;
    private Method unwrapMethod;
    private Method defaultRemoveMethod;
    private Method preDestroyMethod;
    private Method postConstructMethod;
    private Method prePassivateMethod;
    private Method postActivateMethod;
    private Map<String, Method> removeMethods = new HashMap<String, Method>();
    private Set<Method> lifecycleMethods = new HashSet<Method>();
    private Set<Method> conversationManagementMethods = new HashSet<Method>();
    private List<BijectedAttribute<In>> inAttributes = new ArrayList<BijectedAttribute<In>>();
    private List<BijectedAttribute<Out>> outAttributes = new ArrayList<BijectedAttribute<Out>>();
    private List<BijectedAttribute> parameterSetters = new ArrayList<BijectedAttribute>();
    private List<BijectedAttribute> dataModelGetters = new ArrayList<BijectedAttribute>();
    private List<BijectedAttribute> pcAttributes = new ArrayList<BijectedAttribute>();
    private Map<String, BijectedAttribute> dataModelSelectionSetters = new HashMap<String, BijectedAttribute>();
    private List<org.jboss.seam.intercept.Interceptor> interceptors = new ArrayList<org.jboss.seam.intercept.Interceptor>();
    private List<org.jboss.seam.intercept.Interceptor> clientSideInterceptors = new ArrayList<org.jboss.seam.intercept.Interceptor>();
    private Map<Method, InitialValue> initializerSetters = new HashMap<Method, InitialValue>();
    private Map<Field, InitialValue> initializerFields = new HashMap<Field, InitialValue>();
    private List<Field> logFields = new ArrayList<Field>();
    private List<Log> logInstances = new ArrayList<Log>();
    private Collection<Namespace> imports = new ArrayList<Namespace>();
    private Namespace namespace;
    private boolean perNestedConversation;
    private Class<ProxyObject> factory;
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method method) {
            return method.getParameterTypes().length != 0 || !method.getName().equals("finalize");
        }
    };

    public Component(Class<?> clazz) {
        this(clazz, Component.getComponentName(clazz));
    }

    public Component(Class<?> clazz, String componentName) {
        this(clazz, componentName, Seam.getComponentScope(clazz), false, new String[0], null);
    }

    public Component(Class<?> clazz, Context applicationContext) {
        this(clazz, Component.getComponentName(clazz), Seam.getComponentScope(clazz), false, new String[0], null, applicationContext);
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope, boolean startup, String[] dependencies, String jndiName) {
        this(clazz, componentName, componentScope, startup, dependencies, jndiName, Contexts.getApplicationContext());
    }

    private Component(Class<?> beanClass, String componentName, ScopeType componentScope, boolean startup, String[] dependencies, String componentJndiName, Context applicationContext) {
        super(beanClass);
        this.name = componentName;
        this.scope = componentScope;
        this.startup = startup;
        this.dependencies = dependencies;
        this.type = Seam.getComponentType(this.getBeanClass());
        this.interceptionEnabled = Seam.isInterceptionEnabled(this.getBeanClass());
        this.perNestedConversation = Component.hasAnnotation(this.getBeanClass(), PerNestedConversation.class);
        this.checkName();
        this.checkNonabstract();
        this.initNamespace(componentName, applicationContext);
        this.initImports(applicationContext);
        this.initSynchronize();
        this.initStartup();
        this.initSecurity();
        this.checkScopeForComponentType();
        this.checkSynchronizedForComponentType();
        this.checkSerializableForComponentType();
        this.jndiName = componentJndiName == null ? this.getJndiName(applicationContext) : componentJndiName;
        log.info("Component: " + this.getName() + ", scope: " + (Object)((Object)this.getScope()) + ", type: " + (Object)((Object)this.getType()) + ", class: " + this.getBeanClass().getName() + (this.jndiName == null ? "" : ", JNDI: " + this.jndiName));
        this.initMembers(this.getBeanClass(), applicationContext);
        this.checkDefaultRemoveMethod();
        this.businessInterfaces = Component.getBusinessInterfaces(this.getBeanClass());
        if (this.interceptionEnabled) {
            this.initInterceptors();
        }
        this.initInitializers(applicationContext);
        this.registerConverterOrValidator(applicationContext);
    }

    private void checkName() {
        for (char c : this.name.toCharArray()) {
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            throw new IllegalStateException("not a valid Seam component name: " + this.name);
        }
    }

    private void checkNonabstract() {
        if (this.getBeanClass().isInterface()) {
            throw new IllegalArgumentException("component class is an interface: " + this.name);
        }
        if (Modifier.isAbstract(this.getBeanClass().getModifiers())) {
            throw new IllegalArgumentException("component class is abstract: " + this.name);
        }
    }

    private void initStartup() {
        if (this.startup) {
            if (this.scope != ScopeType.SESSION && this.scope != ScopeType.APPLICATION) {
                throw new IllegalArgumentException("@Startup only supported for SESSION or APPLICATION scoped components: " + this.name);
            }
            Startup annotation = this.getBeanClass().getAnnotation(Startup.class);
            if (this.dependencies.length == 0 && annotation != null) {
                this.dependencies = annotation.depends();
            }
        }
    }

    private void initSynchronize() {
        boolean hasAnnotation = this.getBeanClass().isAnnotationPresent(Synchronized.class);
        boolean bl = this.synchronize = this.scope == ScopeType.SESSION || this.scope == ScopeType.PAGE || hasAnnotation;
        if (this.synchronize) {
            long l = this.timeout = this.getBeanClass().isAnnotationPresent(Synchronized.class) ? this.getBeanClass().getAnnotation(Synchronized.class).timeout() : 1000L;
        }
        if (hasAnnotation && !this.interceptionEnabled) {
            log.warn("Interceptors are disabled for @Synchronized component - synchronization will be disabled for: " + this.name);
        }
    }

    private void registerConverterOrValidator(Context applicationContext) {
        Init init;
        if (applicationContext != null && (init = (Init)applicationContext.get(Seam.getComponentName(Init.class))) != null) {
            String id;
            if (this.getBeanClass().isAnnotationPresent(Converter.class)) {
                if (!this.getBeanClass().isAnnotationPresent(BypassInterceptors.class)) {
                    throw new IllegalStateException("Converter " + this.getBeanClass().getName() + " must be annotated with @BypassInterceptors");
                }
                Converter converter = this.getBeanClass().getAnnotation(Converter.class);
                if (converter.forClass() != Void.TYPE) {
                    init.getConvertersByClass().put(converter.forClass(), this.getName());
                }
                id = converter.id().equals("") ? this.getName() : converter.id();
                init.getConverters().put(id, this.getName());
            }
            if (this.getBeanClass().isAnnotationPresent(Validator.class)) {
                if (!this.getBeanClass().isAnnotationPresent(BypassInterceptors.class)) {
                    throw new IllegalStateException("Validator " + this.getBeanClass().getName() + " must be annotated with @BypassInterceptors");
                }
                Validator validator = this.getBeanClass().getAnnotation(Validator.class);
                id = validator.id().equals("") ? this.getName() : validator.id();
                init.getValidators().put(id, this.getName());
            }
        }
    }

    private void initNamespace(String componentName, Context applicationContext) {
        Init init;
        if (applicationContext != null && (init = (Init)applicationContext.get(Seam.getComponentName(Init.class))) != null) {
            this.namespace = init.initNamespaceForName(componentName, true);
        }
    }

    private void initImports(Context applicationContext) {
        Init init;
        if (applicationContext != null && (init = (Init)applicationContext.get(Seam.getComponentName(Init.class))) != null) {
            Package pkg;
            if (this.getBeanClass().isAnnotationPresent(Import.class)) {
                this.addImport(init, this.getBeanClass().getAnnotation(Import.class));
            }
            if ((pkg = this.getBeanClass().getPackage()) != null && pkg.isAnnotationPresent(Import.class)) {
                this.addImport(init, this.getBeanClass().getPackage().getAnnotation(Import.class));
            }
        }
    }

    private void addImport(Init init, Import imp) {
        for (String ns : imp.value()) {
            this.imports.add(init.initNamespaceForName(ns, false));
        }
    }

    private void checkScopeForComponentType() {
        if (this.scope == ScopeType.STATELESS && (this.type == ComponentType.STATEFUL_SESSION_BEAN || this.type == ComponentType.ENTITY_BEAN)) {
            throw new IllegalArgumentException("Only stateless session beans and Java beans may be bound to the STATELESS context: " + this.name);
        }
        if (this.scope == ScopeType.PAGE && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            throw new IllegalArgumentException("Stateful session beans may not be bound to the PAGE context: " + this.name);
        }
        if (this.scope == ScopeType.APPLICATION && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            log.warn("Stateful session beans was bound to the APPLICATION context - note that it is not safe to make concurrent calls to the bean: " + this.name);
        }
        if (this.scope != ScopeType.STATELESS && this.type == ComponentType.MESSAGE_DRIVEN_BEAN) {
            throw new IllegalArgumentException("Message-driven beans must be bound to STATELESS context: " + this.name);
        }
        if (this.scope != ScopeType.STATELESS && this.type == ComponentType.STATELESS_SESSION_BEAN) {
            log.warn("Stateless session beans should only be bound to the STATELESS context:" + this.name);
        }
    }

    protected void checkSynchronizedForComponentType() {
        if (this.scope == ScopeType.STATELESS && this.synchronize) {
            throw new IllegalArgumentException("@Synchronized not meaningful for stateless components: " + this.name);
        }
    }

    private void checkSerializableForComponentType() {
        boolean serializableType;
        boolean serializableScope = this.scope == ScopeType.PAGE || this.scope == ScopeType.SESSION || this.scope == ScopeType.CONVERSATION;
        boolean bl = serializableType = this.type == ComponentType.JAVA_BEAN || this.type == ComponentType.ENTITY_BEAN;
        if (serializableType && serializableScope && !Serializable.class.isAssignableFrom(this.getBeanClass())) {
            log.warn("Component class should be serializable: " + this.name);
        }
    }

    private String getJndiName(Context applicationContext) {
        if (this.getBeanClass().isAnnotationPresent(JndiName.class)) {
            return this.getBeanClass().getAnnotation(JndiName.class).value();
        }
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
        }
        if (applicationContext == null) {
            return null;
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + this.name);
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(this.getBeanClass()));
    }

    private void initInitializers(Context applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map properties = (Map)applicationContext.get(PROPERTIES);
        if (properties == null) {
            return;
        }
        for (Map.Entry me : properties.entrySet()) {
            String key = (String)me.getKey();
            Conversions.PropertyValue propertyValue = (Conversions.PropertyValue)me.getValue();
            if (!key.startsWith(this.name) || key.charAt(this.name.length()) != '.') continue;
            if (log.isDebugEnabled()) {
                log.debug(key + "=" + propertyValue);
            }
            String propertyName = key.substring(this.name.length() + 1, key.length());
            Method setterMethod = null;
            try {
                setterMethod = Reflections.getSetterMethod(this.getBeanClass(), propertyName);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (setterMethod != null) {
                if (!setterMethod.isAccessible()) {
                    setterMethod.setAccessible(true);
                }
                Class<?> parameterClass = setterMethod.getParameterTypes()[0];
                Type parameterType = setterMethod.getGenericParameterTypes()[0];
                this.initializerSetters.put(setterMethod, this.getInitialValueHonoringExceptions(propertyName, propertyValue, parameterClass, parameterType));
                continue;
            }
            Field field = Reflections.getField(this.getBeanClass(), propertyName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            this.initializerFields.put(field, Component.getInitialValue(propertyValue, field.getType(), field.getGenericType()));
        }
    }

    private InitialValue getInitialValueHonoringExceptions(String propertyName, Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
        if ("org.jboss.seam.core.init".equals(this.getName())) {
            return new ConstantInitialValue(propertyValue, parameterClass, parameterType);
        }
        return Component.getInitialValue(propertyValue, parameterClass, parameterType);
    }

    private static InitialValue getInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
        if (parameterClass.equals(Expressions.ValueExpression.class) || parameterClass.equals(Expressions.MethodExpression.class) || propertyValue.isExpression()) {
            return new ELInitialValue(propertyValue, parameterClass, parameterType);
        }
        if (propertyValue.isMultiValued()) {
            if (Set.class.isAssignableFrom(parameterClass)) {
                return new SetInitialValue(propertyValue, parameterClass, parameterType);
            }
            return new ListInitialValue(propertyValue, parameterClass, parameterType);
        }
        if (propertyValue.isAssociativeValued()) {
            return new MapInitialValue(propertyValue, parameterClass, parameterType);
        }
        return new ConstantInitialValue(propertyValue, parameterClass, parameterType);
    }

    private void initMembers(Class<?> clazz, Context applicationContext) {
        BijectedAttribute existing;
        String name;
        Annotation ann;
        HashMap<Method, Annotation> selectionSetters = new HashMap<Method, Annotation>();
        HashMap<Field, Annotation> selectionFields = new HashMap<Field, Annotation>();
        HashSet<String> dataModelNames = new HashSet<String>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                this.scanMethod(applicationContext, selectionSetters, dataModelNames, method);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                this.scanField(selectionFields, dataModelNames, (Field)accessibleObject);
            }
            clazz = clazz.getSuperclass();
        }
        boolean hasMultipleDataModels = this.dataModelGetters.size() > 1;
        String defaultDataModelName = null;
        if (!hasMultipleDataModels && !this.dataModelGetters.isEmpty()) {
            defaultDataModelName = this.dataModelGetters.get(0).getName();
        }
        for (Map.Entry entry : selectionSetters.entrySet()) {
            Method method = (Method)entry.getKey();
            ann = (Annotation)entry.getValue();
            name = this.getDataModelSelectionName(dataModelNames, hasMultipleDataModels, defaultDataModelName, ann);
            existing = this.dataModelSelectionSetters.put(name, new BijectedMethod(this, name, method, ann));
            if (existing == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection setters for: " + name);
        }
        for (Map.Entry entry : selectionFields.entrySet()) {
            Field field = (Field)entry.getKey();
            ann = (Annotation)entry.getValue();
            name = this.getDataModelSelectionName(dataModelNames, hasMultipleDataModels, defaultDataModelName, ann);
            existing = this.dataModelSelectionSetters.put(name, new BijectedField(this, name, field, ann));
            if (existing == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection fields for: " + name);
        }
    }

    private void checkDefaultRemoveMethod() {
        if (this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            if (this.destroyMethod != null && this.destroyMethod.isAnnotationPresent(EJB.REMOVE)) {
                this.defaultRemoveMethod = null;
            } else {
                if (this.defaultRemoveMethod == null) {
                    throw new IllegalArgumentException("Stateful session bean component must have a method with no parameters marked @Remove: " + this.name);
                }
                boolean found = false;
                for (Method remove : this.removeMethods.values()) {
                    if (remove.getParameterTypes().length != 0) continue;
                    if (found) {
                        throw new IllegalStateException("Duplicate default @Remove method for component:" + this.name);
                    }
                    found = true;
                }
            }
        }
    }

    private void scanMethod(Context applicationContext, Map<Method, Annotation> selectionSetters, Set<String> dataModelNames, Method method) {
        Init init;
        String name;
        if (method.isAnnotationPresent(Destroy.class)) {
            if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Destroy methods: " + this.name);
            }
            if (this.destroyMethod != null && !this.destroyMethod.getName().equals(method.getName())) {
                throw new IllegalStateException("component has two @Destroy methods: " + this.name);
            }
            if (this.destroyMethod == null) {
                this.destroyMethod = method;
                this.lifecycleMethods.add(method);
            }
        }
        if (method.isAnnotationPresent(EJB.REMOVE)) {
            this.removeMethods.put(method.getName(), method);
            if (method.getParameterTypes().length == 0) {
                this.defaultRemoveMethod = method;
                this.lifecycleMethods.add(method);
            }
        }
        if (method.isAnnotationPresent(Create.class)) {
            if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Create methods: " + this.name);
            }
            if (this.createMethod != null && !this.createMethod.getName().equals(method.getName())) {
                throw new IllegalStateException("component has two @Create methods: " + this.name);
            }
            if (this.createMethod == null) {
                this.createMethod = method;
                this.lifecycleMethods.add(method);
            }
        }
        if (method.isAnnotationPresent(In.class)) {
            In in = method.getAnnotation(In.class);
            name = Component.toName(in.value(), method);
            this.inAttributes.add(new BijectedMethod(this, name, method, in));
        }
        if (method.isAnnotationPresent(Out.class)) {
            Out out = method.getAnnotation(Out.class);
            name = Component.toName(out.value(), method);
            this.outAttributes.add(new BijectedMethod(this, name, method, out));
            Init init2 = (Init)applicationContext.get(Seam.getComponentName(Init.class));
            init2.initNamespaceForName(name, true);
        }
        if (method.isAnnotationPresent(Unwrap.class)) {
            if (this.unwrapMethod != null && !this.unwrapMethod.getName().equals(method.getName())) {
                throw new IllegalStateException("component has two @Unwrap methods: " + this.name);
            }
            if (this.unwrapMethod == null) {
                this.unwrapMethod = method;
            }
        }
        if (method.isAnnotationPresent(DataModel.class)) {
            this.checkDataModelScope(method.getAnnotation(DataModel.class));
        }
        if (method.isAnnotationPresent(Factory.class)) {
            init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
            String contextVariable = Component.toName(method.getAnnotation(Factory.class).value(), method);
            if (contextVariable.equals(this.name)) {
                throw new IllegalStateException("@Factory method can not share name with its containing component: " + contextVariable);
            }
            init.addFactoryMethod(contextVariable, method, this);
            if (method.getAnnotation(Factory.class).autoCreate()) {
                init.addAutocreateVariable(contextVariable);
            }
        }
        if (method.isAnnotationPresent(Observer.class)) {
            init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
            Observer observer = method.getAnnotation(Observer.class);
            for (String eventType : observer.value()) {
                if (eventType.length() == 0) {
                    eventType = method.getName();
                }
                init.addObserverMethod(eventType, method, this, observer.create());
            }
        }
        if (method.isAnnotationPresent(RequestParameter.class)) {
            RequestParameter rp = method.getAnnotation(RequestParameter.class);
            name = Component.toName(rp.value(), method);
            this.parameterSetters.add(new BijectedMethod(this, name, method, rp));
        }
        if (method.isAnnotationPresent(EJB.PRE_PASSIVATE)) {
            this.prePassivateMethod = method;
            this.lifecycleMethods.add(method);
        }
        if (method.isAnnotationPresent(EJB.POST_ACTIVATE)) {
            this.postActivateMethod = method;
            this.lifecycleMethods.add(method);
        }
        if (method.isAnnotationPresent(EJB.POST_CONSTRUCT)) {
            this.postConstructMethod = method;
            this.lifecycleMethods.add(method);
        }
        if (method.isAnnotationPresent(EJB.PRE_DESTROY)) {
            this.preDestroyMethod = method;
            this.lifecycleMethods.add(method);
        }
        if (method.isAnnotationPresent(EJB.PERSISTENCE_CONTEXT)) {
            this.checkPersistenceContextForComponentType();
            this.pcAttributes.add(new BijectedMethod(this, Component.toName(null, method), method, null));
        }
        if (method.isAnnotationPresent(Begin.class) || method.isAnnotationPresent(End.class) || method.isAnnotationPresent(StartTask.class) || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(EndTask.class)) {
            this.conversationManagementMethods.add(method);
        }
        for (Annotation ann : method.getAnnotations()) {
            if (ann.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                String name2 = Component.toName(Component.createWrapper(ann).getVariableName(ann), method);
                this.dataModelGetters.add(new BijectedProperty(this, name2, method, ann));
                dataModelNames.add(name2);
            }
            if (!ann.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
            selectionSetters.put(method, ann);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    private void scanField(Map<Field, Annotation> selectionFields, Set<String> dataModelNames, Field field) {
        String name;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (field.isAnnotationPresent(In.class)) {
            In in = field.getAnnotation(In.class);
            name = Component.toName(in.value(), field);
            this.inAttributes.add(new BijectedField(this, name, field, in));
        }
        if (field.isAnnotationPresent(Out.class)) {
            Out out = field.getAnnotation(Out.class);
            name = Component.toName(out.value(), field);
            this.outAttributes.add(new BijectedField(this, name, field, out));
        }
        if (field.isAnnotationPresent(DataModel.class)) {
            this.checkDataModelScope(field.getAnnotation(DataModel.class));
        }
        if (field.isAnnotationPresent(RequestParameter.class)) {
            RequestParameter rp = field.getAnnotation(RequestParameter.class);
            name = Component.toName(rp.value(), field);
            this.parameterSetters.add(new BijectedField(this, name, field, rp));
        }
        if (field.isAnnotationPresent(Logger.class)) {
            String category = field.getAnnotation(Logger.class).value();
            Log logInstance = "".equals(category) ? Logging.getLog(this.getBeanClass()) : Logging.getLog(category);
            if (Modifier.isStatic(field.getModifiers())) {
                Reflections.setAndWrap(field, null, logInstance);
            } else {
                this.logFields.add(field);
                this.logInstances.add(logInstance);
            }
        }
        if (field.isAnnotationPresent(EJB.PERSISTENCE_CONTEXT)) {
            this.checkPersistenceContextForComponentType();
            this.pcAttributes.add(new BijectedField(this, Component.toName(null, field), field, null));
        }
        for (Annotation ann : field.getAnnotations()) {
            if (ann.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                String name2 = Component.toName(Component.createWrapper(ann).getVariableName(ann), field);
                this.dataModelGetters.add(new BijectedField(this, name2, field, ann));
                dataModelNames.add(name2);
            }
            if (!ann.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
            selectionFields.put(field, ann);
        }
    }

    protected void checkPersistenceContextForComponentType() {
        if (!this.type.isSessionBean() && this.type != ComponentType.MESSAGE_DRIVEN_BEAN) {
            throw new IllegalArgumentException("@PersistenceContext may only be used on session bean or message driven bean components: " + this.name);
        }
    }

    private String getDataModelSelectionName(Set<String> dataModelNames, boolean hasMultipleDataModels, String defaultDataModelName, Annotation ann) {
        String name = Component.createUnwrapper(ann).getVariableName(ann);
        if (name.length() == 0) {
            if (hasMultipleDataModels) {
                throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
            }
            if (defaultDataModelName == null) {
                throw new IllegalStateException("No @DataModel for @DataModelSelection: " + name);
            }
            return defaultDataModelName;
        }
        if (!dataModelNames.contains(name)) {
            throw new IllegalStateException("No @DataModel for @DataModelSelection: " + name);
        }
        return name;
    }

    private void checkDataModelScope(DataModel dataModel) {
        ScopeType dataModelScope = dataModel.scope();
        if (dataModelScope != ScopeType.PAGE && dataModelScope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("@DataModel scope must be ScopeType.UNSPECIFIED or ScopeType.PAGE: " + this.name);
        }
    }

    private void initInterceptors() {
        this.initDefaultInterceptors();
        for (Annotation annotation : this.getBeanClass().getAnnotations()) {
            Class[] classes;
            if (annotation.annotationType().isAnnotationPresent(EJB.INTERCEPTORS)) {
                classes = EJB.value(annotation.annotationType().getAnnotation(EJB.INTERCEPTORS));
                this.addInterceptor(new org.jboss.seam.intercept.Interceptor(classes, annotation, this));
            }
            if (!annotation.annotationType().isAnnotationPresent(Interceptors.class)) continue;
            classes = annotation.annotationType().getAnnotation(Interceptors.class).value();
            this.addInterceptor(new org.jboss.seam.intercept.Interceptor(classes, annotation, this));
        }
        this.newSort(this.interceptors);
        this.newSort(this.clientSideInterceptors);
        if (log.isDebugEnabled()) {
            log.debug("interceptor stack: " + this.interceptors);
        }
    }

    public void addInterceptor(Object interceptorInstance) {
        try {
            this.addInterceptor(new org.jboss.seam.intercept.Interceptor(interceptorInstance, this));
        }
        catch (NoClassDefFoundError e) {
            log.debug("Unable to load interceptor " + interceptorInstance.getClass(), e);
        }
        catch (TypeNotPresentException e) {
            log.debug("Unable to load interceptor " + interceptorInstance.getClass(), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load interceptor " + interceptorInstance.getClass(), e);
        }
    }

    public void addInterceptor(org.jboss.seam.intercept.Interceptor interceptor) {
        if (interceptor.isInterceptorEnabled()) {
            if (interceptor.getType() == InterceptorType.SERVER) {
                this.interceptors.add(interceptor);
            } else {
                this.clientSideInterceptors.add(interceptor);
            }
        }
    }

    private List<org.jboss.seam.intercept.Interceptor> newSort(List<org.jboss.seam.intercept.Interceptor> list) {
        List siList = new ArrayList();
        HashMap<Class, SortItem<org.jboss.seam.intercept.Interceptor>> ht = new HashMap<Class, SortItem<org.jboss.seam.intercept.Interceptor>>();
        for (org.jboss.seam.intercept.Interceptor interceptor : list) {
            SortItem<org.jboss.seam.intercept.Interceptor> sortItem = new SortItem<org.jboss.seam.intercept.Interceptor>(interceptor);
            siList.add(sortItem);
            ht.put(interceptor.getUserInterceptorClass(), sortItem);
        }
        for (SortItem sortItem : siList) {
            Class clazz = ((org.jboss.seam.intercept.Interceptor)sortItem.getObj()).getUserInterceptorClass();
            Interceptor interceptorAnn = this.seamInterceptor(clazz);
            if (interceptorAnn == null) continue;
            for (Class cl : Arrays.asList(interceptorAnn.around())) {
                if (!this.isCompatibleInterceptor(interceptorAnn, this.seamInterceptor(cl))) {
                    log.warn("Interceptor " + clazz + " has different type than around interceptor " + cl);
                }
                sortItem.addAround((SortItem)ht.get(cl));
            }
            for (Class cl : Arrays.asList(interceptorAnn.within())) {
                if (!this.isCompatibleInterceptor(interceptorAnn, this.seamInterceptor(cl))) {
                    log.warn("Interceptor " + clazz + " has different type than within interceptor " + cl);
                }
                sortItem.addWithin((SortItem)ht.get(cl));
            }
        }
        Sorter sList = new Sorter();
        siList = sList.sort(siList);
        list.clear();
        for (SortItem sortItem : siList) {
            list.add((org.jboss.seam.intercept.Interceptor)sortItem.getObj());
        }
        return list;
    }

    private Interceptor seamInterceptor(Class<?> clazz) {
        return clazz.getAnnotation(Interceptor.class);
    }

    private boolean isCompatibleInterceptor(Interceptor anno1, Interceptor anno2) {
        if (anno1 == null || anno2 == null) {
            return true;
        }
        if (anno1.type() == InterceptorType.CLIENT && anno2.type() == InterceptorType.SERVER) {
            return false;
        }
        return anno2.type() != InterceptorType.CLIENT || anno2.type() != InterceptorType.SERVER;
    }

    private void initDefaultInterceptors() {
        List<String> interceptors = Contexts.isApplicationContextActive() ? Init.instance().getInterceptors() : Init.DEFAULT_INTERCEPTORS;
        for (String interceptorName : interceptors) {
            Object interceptorInstance = null;
            try {
                Class clazz = Reflections.classForName(interceptorName);
                interceptorInstance = clazz.newInstance();
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to load interceptor " + interceptorName, e);
            }
            catch (TypeNotPresentException e) {
                log.debug("Unable to load interceptor " + interceptorName, e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load interceptor " + interceptorName, e);
            }
            this.addInterceptor((Object)interceptorInstance);
        }
    }

    private void initSecurity() {
        if (this.beanClassHasAnnotation(Restrict.class)) {
            this.secure = true;
            return;
        }
        for (Annotation annotation : this.getBeanClass().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
            this.secure = true;
            return;
        }
        for (Method method : this.getBeanClass().getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(PermissionCheck.class) && !annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
                this.secure = true;
                return;
            }
            Annotation[] arr$ = method.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation annotations;
                for (Annotation annotation : annotations = arr$[i$]) {
                    if (!annotation.annotationType().isAnnotationPresent(PermissionCheck.class)) continue;
                    this.secure = true;
                    return;
                }
            }
        }
    }

    private static boolean hasAnnotation(Class clazz, Class annotationType) {
        if (clazz.isAnnotationPresent(annotationType)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotation(Class clazz, String annotationName) {
        for (Annotation a : clazz.getAnnotations()) {
            if (!a.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        for (Method method : clazz.getMethods()) {
            for (Annotation a : method.getAnnotations()) {
                if (!a.annotationType().getName().equals(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean beanClassHasAnnotation(Class annotationType) {
        return Component.hasAnnotation(this.getBeanClass(), annotationType);
    }

    public boolean beanClassHasAnnotation(String annotationName) {
        return Component.hasAnnotation(this.getBeanClass(), annotationName);
    }

    public boolean businessInterfaceHasAnnotation(Class annotationType) {
        for (Class businessInterface : this.getBusinessInterfaces()) {
            if (!Component.hasAnnotation(businessInterface, annotationType)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public ComponentType getType() {
        return this.type;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public List<org.jboss.seam.intercept.Interceptor> getInterceptors(InterceptorType type) {
        switch (type) {
            case SERVER: {
                return this.interceptors;
            }
            case CLIENT: {
                return this.clientSideInterceptors;
            }
            case ANY: {
                ArrayList<org.jboss.seam.intercept.Interceptor> all = new ArrayList<org.jboss.seam.intercept.Interceptor>();
                all.addAll(this.clientSideInterceptors);
                all.addAll(this.interceptors);
                return all;
            }
        }
        throw new IllegalArgumentException("no interceptor type specified");
    }

    public List<Object> createUserInterceptors(InterceptorType type) {
        List<org.jboss.seam.intercept.Interceptor> interceptors = this.getInterceptors(type);
        ArrayList<Object> result = new ArrayList<Object>(interceptors.size());
        for (org.jboss.seam.intercept.Interceptor interceptor : interceptors) {
            result.add(interceptor.createUserInterceptor());
        }
        return result;
    }

    public List<org.jboss.seam.intercept.Interceptor> getServerSideInterceptors() {
        return this.getInterceptors(InterceptorType.SERVER);
    }

    public List<org.jboss.seam.intercept.Interceptor> getClientSideInterceptors() {
        return this.getInterceptors(InterceptorType.CLIENT);
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods.values();
    }

    public Method getRemoveMethod(String name) {
        return this.removeMethods.get(name);
    }

    public boolean hasPreDestroyMethod() {
        return this.preDestroyMethod != null;
    }

    public boolean hasPostConstructMethod() {
        return this.postConstructMethod != null;
    }

    public boolean hasPrePassivateMethod() {
        return this.prePassivateMethod != null;
    }

    public boolean hasPostActivateMethod() {
        return this.postActivateMethod != null;
    }

    public boolean hasDestroyMethod() {
        return this.destroyMethod != null;
    }

    public boolean hasCreateMethod() {
        return this.createMethod != null;
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public boolean hasUnwrapMethod() {
        return this.unwrapMethod != null;
    }

    public Method getUnwrapMethod() {
        return this.unwrapMethod;
    }

    public List<BijectedAttribute<Out>> getOutAttributes() {
        return this.outAttributes;
    }

    public List<BijectedAttribute<In>> getInAttributes() {
        return this.inAttributes;
    }

    public boolean needsInjection() {
        return !this.getInAttributes().isEmpty() || !this.dataModelSelectionSetters.isEmpty() || !this.parameterSetters.isEmpty();
    }

    public boolean needsOutjection() {
        return !this.getOutAttributes().isEmpty() || !this.dataModelGetters.isEmpty();
    }

    protected Object instantiate() throws Exception {
        switch (this.type) {
            case JAVA_BEAN: {
                return this.instantiateJavaBean();
            }
            case ENTITY_BEAN: {
                return this.instantiateEntityBean();
            }
            case STATELESS_SESSION_BEAN: 
            case STATEFUL_SESSION_BEAN: {
                return this.instantiateSessionBean();
            }
            case MESSAGE_DRIVEN_BEAN: {
                throw new UnsupportedOperationException("Message-driven beans may not be called: " + this.name);
            }
        }
        throw new IllegalStateException();
    }

    protected void postConstruct(Object bean) throws Exception {
        switch (this.type) {
            case JAVA_BEAN: {
                this.postConstructJavaBean(bean);
                break;
            }
            case ENTITY_BEAN: {
                this.postConstructEntityBean(bean);
                break;
            }
            case STATELESS_SESSION_BEAN: 
            case STATEFUL_SESSION_BEAN: {
                this.postConstructSessionBean(bean);
                break;
            }
            case MESSAGE_DRIVEN_BEAN: {
                throw new UnsupportedOperationException("Message-driven beans may not be called: " + this.name);
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateSessionBean() throws Exception, NamingException {
        Component old = (Component)SeamInterceptor.COMPONENT.get();
        SeamInterceptor.COMPONENT.set(this);
        try {
            Object bean = Naming.getInitialContext().lookup(this.jndiName);
            Object object = this.wrap(bean, new ClientSideInterceptor(bean, this));
            return object;
        }
        finally {
            SeamInterceptor.COMPONENT.set(old);
        }
    }

    protected void postConstructSessionBean(Object bean) throws Exception, NamingException {
    }

    protected Object instantiateEntityBean() throws Exception {
        Constructor<?> constructor = this.getBeanClass().getConstructor(new Class[0]);
        boolean accessible = constructor.isAccessible();
        if (Modifier.isProtected(constructor.getModifiers())) {
            constructor.setAccessible(true);
        }
        Object bean = this.getBeanClass().newInstance();
        constructor.setAccessible(accessible);
        return bean;
    }

    protected void postConstructEntityBean(Object bean) throws Exception {
        this.initialize(bean);
    }

    protected Object instantiateJavaBean() throws Exception {
        Object bean = this.getBeanClass().newInstance();
        if (this.interceptionEnabled) {
            JavaBeanInterceptor interceptor = new JavaBeanInterceptor(bean, this);
            bean = this.wrap(bean, interceptor);
        }
        return bean;
    }

    protected void postConstructJavaBean(Object bean) throws Exception {
        if (!this.interceptionEnabled) {
            this.initialize(bean);
            this.callPostConstructMethod(bean);
        } else if (bean instanceof Proxy) {
            Proxy proxy = (Proxy)bean;
            JavaBeanInterceptor interceptor = (JavaBeanInterceptor)proxy.writeReplace();
            interceptor.postConstruct();
        }
    }

    public void destroy(Object bean) {
        try {
            this.callDestroyMethod(bean);
        }
        catch (Exception e) {
            log.warn("Exception calling component @Destroy method: " + this.name, e);
        }
        if (this.getType() == ComponentType.STATEFUL_SESSION_BEAN) {
            try {
                this.callDefaultRemoveMethod(bean);
            }
            catch (Exception e) {
                log.warn("Exception calling stateful session bean default @Remove method: " + this.name, e);
            }
        } else if (this.getType() == ComponentType.JAVA_BEAN) {
            try {
                this.callPreDestroyMethod(bean);
            }
            catch (Exception e) {
                log.warn("Exception calling JavaBean @PreDestroy method: " + this.name, e);
            }
        }
    }

    public Object wrap(Object bean, MethodHandler interceptor) throws Exception {
        ProxyObject proxy = this.getProxyFactory().newInstance();
        proxy.setHandler(interceptor);
        return proxy;
    }

    private synchronized Class<ProxyObject> getProxyFactory() {
        if (this.factory == null) {
            this.factory = Component.createProxyFactory(this.getType(), this.getBeanClass(), this.getBusinessInterfaces());
        }
        return this.factory;
    }

    public void initialize(Object bean) throws Exception {
        Object initialValue;
        if (log.isTraceEnabled()) {
            log.trace("initializing new instance of: " + this.name);
        }
        this.injectLog(bean);
        for (Map.Entry<Method, InitialValue> entry : this.initializerSetters.entrySet()) {
            Method method = entry.getKey();
            initialValue = entry.getValue().getValue(method.getParameterTypes()[0]);
            this.setPropertyValue(bean, method, method.getName(), initialValue);
        }
        for (Map.Entry<AccessibleObject, InitialValue> entry : this.initializerFields.entrySet()) {
            Field field = (Field)entry.getKey();
            initialValue = entry.getValue().getValue(field.getType());
            this.setFieldValue(bean, field, field.getName(), initialValue);
        }
        if (log.isTraceEnabled()) {
            log.trace("done initializing: " + this.name);
        }
    }

    public void inject(Object bean, boolean enforceRequired) {
        if (log.isTraceEnabled()) {
            log.trace("injecting dependencies of: " + this.getName());
        }
        this.injectAttributes(bean, enforceRequired);
        this.injectDataModelSelections(bean);
        this.injectParameters(bean);
    }

    public void disinject(Object bean) {
        if (log.isTraceEnabled()) {
            log.trace("disinjecting dependencies of: " + this.getName());
        }
        this.disinjectAttributes(bean);
    }

    private void injectLog(Object bean) {
        for (int i = 0; i < this.logFields.size(); ++i) {
            this.setFieldValue(bean, this.logFields.get(i), "log", this.logInstances.get(i));
        }
    }

    private void injectParameters(Object bean) {
        Parameters params = Parameters.instance();
        if (params != null) {
            Map<String, String[]> requestParameters = params.getRequestParameters();
            for (BijectedAttribute setter : this.parameterSetters) {
                Object convertedValue = params.convertMultiValueRequestParameter(requestParameters, setter.getName(), setter.getType());
                setter.set(bean, convertedValue);
            }
        }
    }

    public void outject(Object bean, boolean enforceRequired) {
        if (log.isTraceEnabled()) {
            log.trace("outjecting dependencies of: " + this.getName());
        }
        this.outjectAttributes(bean, enforceRequired);
        this.outjectDataModels(bean);
    }

    private void injectDataModelSelections(Object bean) {
        for (BijectedAttribute dataModelGetter : this.dataModelGetters) {
            this.injectDataModelSelection(bean, dataModelGetter);
        }
    }

    private void injectDataModelSelection(Object bean, BijectedAttribute dataModelGetter) {
        DataBinder wrapper = Component.createWrapper(dataModelGetter.getAnnotation());
        String name = dataModelGetter.getName();
        Object dataModelAnn = dataModelGetter.getAnnotation();
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Object dataModel = Component.getOutScope(scope, this).getContext().get(name);
        if (dataModel != null) {
            BijectedAttribute setter;
            if (ScopeType.PAGE.equals((Object)scope)) {
                dataModelGetter.set(bean, wrapper.getWrappedData(dataModelAnn, dataModel));
            }
            Object selectedIndex = wrapper.getSelection(dataModelAnn, dataModel);
            if (log.isDebugEnabled()) {
                log.debug("selected row: " + selectedIndex);
            }
            if (selectedIndex != null && (setter = this.dataModelSelectionSetters.get(name)) != null) {
                Object dataModelSelectionAnn = setter.getAnnotation();
                Object selection = Component.createUnwrapper(dataModelSelectionAnn).getSelection(dataModelSelectionAnn, dataModel);
                setter.set(bean, selection);
            }
        }
    }

    private void outjectDataModels(Object bean) {
        for (BijectedAttribute dataModelGetter : this.dataModelGetters) {
            this.outjectDataModel(bean, dataModelGetter);
        }
    }

    private void outjectDataModel(Object bean, BijectedAttribute dataModelGetter) {
        boolean reoutject;
        DataBinder wrapper = Component.createWrapper(dataModelGetter.getAnnotation());
        Object list = dataModelGetter.get(bean);
        String name = dataModelGetter.getName();
        Object dataModelAnn = dataModelGetter.getAnnotation();
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Context context = Component.getOutScope(scope, this).getContext();
        Object existingDataModel = context.get(name);
        boolean dirty = existingDataModel == null || wrapper.isDirty(dataModelAnn, existingDataModel, list);
        boolean bl = reoutject = existingDataModel != null && scope == ScopeType.PAGE;
        if (dirty) {
            if (list != null) {
                context.set(name, wrapper.wrap(dataModelAnn, list));
            } else {
                context.remove(name);
            }
        } else if (reoutject) {
            context.set(name, existingDataModel);
        }
    }

    private static DataBinder createWrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataBinderClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DataSelector createUnwrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataSelectorClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ScopeType getOutScope(ScopeType specifiedScope, Component component) {
        ScopeType scope;
        ScopeType scopeType = scope = component == null ? ScopeType.EVENT : component.getScope();
        if (scope == ScopeType.STATELESS) {
            scope = ScopeType.EVENT;
        }
        if (specifiedScope != ScopeType.UNSPECIFIED) {
            scope = specifiedScope;
        }
        return scope;
    }

    private void injectAttributes(Object bean, boolean enforceRequired) {
        for (BijectedAttribute<In> att : this.getInAttributes()) {
            att.set(bean, this.getValueToInject(att.getAnnotation(), att.getName(), bean, enforceRequired));
        }
    }

    private void disinjectAttributes(Object bean) {
        for (BijectedAttribute<In> att : this.getInAttributes()) {
            if (att.getType().isPrimitive()) continue;
            att.set(bean, null);
        }
    }

    private void outjectAttributes(Object bean, boolean enforceRequired) {
        for (BijectedAttribute<Out> att : this.getOutAttributes()) {
            this.outjectAttribute(att.getAnnotation(), att.getName(), bean, att.get(bean), enforceRequired);
        }
    }

    private void outjectAttribute(Out out, String name, Object bean, Object value, boolean enforceRequired) {
        ScopeType outScope;
        if (value == null && enforceRequired && out.required()) {
            throw new RequiredException("@Out attribute requires non-null value: " + this.getAttributeMessage(name));
        }
        Component component = null;
        if (out.scope() == ScopeType.UNSPECIFIED) {
            component = Component.forName(name);
            if (value != null && component != null && !component.isInstance(value)) {
                throw new IllegalArgumentException("attempted to bind an @Out attribute of the wrong type to: " + this.getAttributeMessage(name));
            }
        } else if (out.scope() == ScopeType.STATELESS) {
            throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @Out: " + this.getAttributeMessage(name));
        }
        ScopeType scopeType = outScope = component == null ? Component.getOutScope(out.scope(), this) : component.getScope();
        if (enforceRequired || outScope.isContextActive()) {
            if (value == null) {
                outScope.getContext().remove(name);
            } else {
                outScope.getContext().set(name, value);
            }
        }
    }

    public boolean isInstance(Object bean) {
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return this.getBeanClass().isInstance(bean);
            }
        }
        Class<?> clazz = bean.getClass();
        for (Class businessInterface : this.businessInterfaces) {
            if (!businessInterface.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class> getBusinessInterfaces(Class clazz) {
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        if (clazz.isAnnotationPresent(EJB.LOCAL)) {
            for (Class clazz2 : EJB.value(clazz.getAnnotation(EJB.LOCAL))) {
                result.add(clazz2);
            }
        }
        if (clazz.isAnnotationPresent(EJB.REMOTE)) {
            for (Class clazz3 : EJB.value(clazz.getAnnotation(EJB.REMOTE))) {
                result.add(clazz3);
            }
        }
        for (Class clazz4 : clazz.getInterfaces()) {
            if (!clazz4.isAnnotationPresent(EJB.LOCAL) && !clazz4.isAnnotationPresent(EJB.REMOTE)) continue;
            result.add(clazz4);
        }
        if (result.isEmpty()) {
            for (Class clazz5 : clazz.getInterfaces()) {
                if (Component.isExcludedLocalInterfaceName(clazz5.getName())) continue;
                result.add(clazz5);
            }
        }
        return result;
    }

    public Set<Class> getBusinessInterfaces() {
        return this.businessInterfaces;
    }

    private static boolean isExcludedLocalInterfaceName(String name) {
        return name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.");
    }

    private Object getFieldValue(Object bean, Field field, String name) {
        try {
            return Reflections.get(field, bean);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get field value: " + this.getAttributeMessage(name), e);
        }
    }

    private Object getPropertyValue(Object bean, Method method, String name) {
        try {
            return Reflections.invoke(method, bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setPropertyValue(Object bean, Method method, String name, Object value) {
        try {
            Reflections.invoke(method, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setFieldValue(Object bean, Field field, String name, Object value) {
        try {
            Reflections.set(field, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set field value: " + this.getAttributeMessage(name), e);
        }
    }

    public static String getComponentName(Class<?> clazz) {
        String componentName = Seam.getComponentName(clazz);
        if (componentName == null) {
            throw new IllegalArgumentException("No @Name annotation for class: " + clazz.getName());
        }
        return componentName;
    }

    public static Component forName(String name) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        return (Component)Contexts.getApplicationContext().get(name + ".component");
    }

    public static Object getInstance(Class<?> clazz) {
        return Component.getInstance(clazz, true);
    }

    public static Object getInstance(Class<?> clazz, boolean create) {
        return Component.getInstance(Component.getComponentName(clazz), create);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope) {
        return Component.getInstance(clazz, scope, true);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope, boolean create) {
        return Component.getInstance(Component.getComponentName(clazz), scope, create);
    }

    public static Object getInstance(String name) {
        return Component.getInstance(name, true);
    }

    public static Object getInstance(String name, boolean create) {
        return Component.getInstance(name, create, true);
    }

    public static Object getInstance(String name, boolean create, boolean allowAutocreation) {
        Object result = Contexts.lookupInStatefulContexts(name);
        result = Component.getInstance(name, create, allowAutocreation, result, null);
        return result;
    }

    public static Object getInstance(String name, ScopeType scope) {
        return Component.getInstance(name, scope, true);
    }

    public static Object getInstance(String name, ScopeType scope, boolean create) {
        return Component.getInstance(name, scope, create, true);
    }

    public static Object getInstance(String name, ScopeType scope, boolean create, boolean allowAutocreation) {
        Object result = scope == ScopeType.STATELESS ? null : scope.getContext().get(name);
        result = Component.getInstance(name, create, allowAutocreation, result, scope);
        return result;
    }

    private static Object getInstance(String name, boolean create, boolean allowAutoCreation, Object result, ScopeType scope) {
        Component component = Component.forName(name);
        boolean bl = create = create || Init.instance().isAutocreateVariable(name) && allowAutoCreation;
        if (result == null && create && (result = Component.getInstanceFromFactory(name, scope)) == null) {
            if (component == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Seam component not found: " + name);
                }
            } else if (component.getScope().isContextActive()) {
                result = component.newInstance();
            } else {
                log.warn("Cannot create Seam component, scope is not active: " + name + "(" + component.getScope().name() + ")");
            }
        }
        if (result != null && component != null) {
            if (!component.isInstance(result)) {
                if (component.hasUnwrapMethod()) {
                    return result;
                }
                throw new IllegalArgumentException("value of context variable is not an instance of the component bound to the context variable: " + name + ". If you are using hot deploy, you may have attempted to hot deploy a session or " + "application-scoped component definition while using an old instance in the session.");
            }
            result = component.unwrap(result);
        }
        return result;
    }

    public static Object getInstanceFromFactory(String name) {
        return Component.getInstanceFromFactory(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getInstanceFromFactory(String name, ScopeType scope) {
        Init init = Init.instance();
        if (init == null) {
            return null;
        }
        Init.FactoryMethod factoryMethod = init.getFactory(name);
        Init.FactoryExpression methodBinding = init.getFactoryMethodExpression(name);
        Init.FactoryExpression valueBinding = init.getFactoryValueExpression(name);
        if (methodBinding != null && Component.getOutScope(methodBinding.getScope(), null).isContextActive()) {
            Object result = methodBinding.getMethodBinding().invoke(new Object[0]);
            return Component.handleFactoryMethodResult(name, null, result, methodBinding.getScope());
        }
        if (valueBinding != null && Component.getOutScope(valueBinding.getScope(), null).isContextActive()) {
            Object result = valueBinding.getValueBinding().getValue();
            return Component.handleFactoryMethodResult(name, null, result, valueBinding.getScope());
        }
        if (factoryMethod != null && Component.getOutScope(factoryMethod.getScope(), factoryMethod.getComponent()).isContextActive()) {
            Object factory = Component.getInstance(factoryMethod.getComponent().getName(), true);
            factoryLock.lock();
            try {
                Object value;
                if (scope != ScopeType.STATELESS) {
                    Object object = value = scope == null ? Contexts.lookupInStatefulContexts(name) : scope.getContext().get(name);
                    if (value != null) {
                        Object object2 = value;
                        return object2;
                    }
                }
                if (factory == null) {
                    value = null;
                    return value;
                }
                Object result = factoryMethod.getComponent().callComponentMethod(factory, factoryMethod.getMethod(), new Object[0]);
                Object object = Component.handleFactoryMethodResult(name, factoryMethod.getComponent(), result, factoryMethod.getScope());
                return object;
            }
            finally {
                factoryLock.unlock();
            }
        }
        return null;
    }

    private static Object handleFactoryMethodResult(String name, Component component, Object result, ScopeType scope) {
        Object value = Contexts.lookupInStatefulContexts(name);
        if (value == null) {
            ScopeType outScope = Component.getOutScope(scope, component);
            if (outScope != ScopeType.STATELESS && result != null) {
                outScope.getContext().set(name, result);
            }
            return result;
        }
        if (scope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("factory method with defined scope outjected a value: " + name);
        }
        return value;
    }

    public Object newInstance() {
        Object instance;
        if (log.isTraceEnabled()) {
            log.trace("instantiating Seam component: " + this.name);
        }
        try {
            instance = this.instantiate();
            if (this.getScope() != ScopeType.STATELESS) {
                this.getScope().getContext().set(this.name, instance);
            }
            this.postConstruct(instance);
            if (this.getScope() != ScopeType.STATELESS) {
                this.callCreateMethod(instance);
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.postCreate." + this.name, instance);
                }
            }
        }
        catch (Exception e) {
            if (this.getScope() != ScopeType.STATELESS) {
                this.getScope().getContext().remove(this.name);
            }
            throw new InstantiationException("Could not instantiate Seam component: " + this.name, e);
        }
        return instance;
    }

    private void callDefaultRemoveMethod(Object instance) {
        if (this.hasDefaultRemoveMethod()) {
            this.callComponentMethod(instance, this.getDefaultRemoveMethod(), new Object[0]);
        }
    }

    public boolean hasDefaultRemoveMethod() {
        return this.defaultRemoveMethod != null;
    }

    public Method getDefaultRemoveMethod() {
        return this.defaultRemoveMethod;
    }

    public void callCreateMethod(Object instance) {
        if (this.hasCreateMethod()) {
            this.callComponentMethod(instance, this.getCreateMethod(), new Object[0]);
        }
    }

    public void callDestroyMethod(Object instance) {
        if (this.hasDestroyMethod()) {
            this.callComponentMethod(instance, this.getDestroyMethod(), new Object[0]);
        }
    }

    public void callPreDestroyMethod(Object instance) {
        if (this.hasPreDestroyMethod()) {
            this.callComponentMethod(instance, this.getPreDestroyMethod(), new Object[0]);
        }
    }

    public void callPostConstructMethod(Object instance) {
        if (this.hasPostConstructMethod()) {
            this.callComponentMethod(instance, this.getPostConstructMethod(), new Object[0]);
        }
    }

    public void callPrePassivateMethod(Object instance) {
        if (this.hasPrePassivateMethod()) {
            this.callComponentMethod(instance, this.getPrePassivateMethod(), new Object[0]);
        }
    }

    public void callPostActivateMethod(Object instance) {
        if (this.hasPostActivateMethod()) {
            this.callComponentMethod(instance, this.getPostActivateMethod(), new Object[0]);
        }
    }

    public Method getPostActivateMethod() {
        return this.postActivateMethod;
    }

    public Method getPrePassivateMethod() {
        return this.prePassivateMethod;
    }

    public Method getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public Method getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Object callComponentMethod(Object instance, Method method, Object ... parameters) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String methodName = method.getName();
        try {
            Method interfaceMethod = instance.getClass().getMethod(methodName, paramTypes);
            if (paramTypes.length == 0 || interfaceMethod.getParameterTypes().length == 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, new Object[0]);
            }
            if (parameters.length > 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, parameters);
            }
            return Reflections.invokeAndWrap(interfaceMethod, instance, this);
        }
        catch (NoSuchMethodException e) {
            String message = "method not found: " + method.getName() + " for component: " + this.name;
            if (this.getType().isSessionBean()) {
                message = message + " (check that it is declared on the session bean business interface)";
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    private Object unwrap(Object instance) {
        if (this.hasUnwrapMethod()) {
            return this.callComponentMethod(instance, this.getUnwrapMethod(), new Object[0]);
        }
        return instance;
    }

    private Object getValueToInject(In in, String name, Object bean, boolean enforceRequired) {
        Object result;
        if (name.startsWith("#")) {
            if (log.isDebugEnabled()) {
                log.debug("trying to inject with EL expression: " + name);
            }
            result = Expressions.instance().createValueExpression(name).getValue();
        } else if (in.scope() == ScopeType.UNSPECIFIED) {
            if (log.isDebugEnabled()) {
                log.debug("trying to inject with hierarchical context search: " + name);
            }
            boolean create = in.create() && !Lifecycle.isDestroying();
            result = this.getInstanceInAllNamespaces(name, create);
        } else {
            if (in.create()) {
                throw new IllegalArgumentException("cannot combine create=true with explicit scope on @In: " + this.getAttributeMessage(name));
            }
            if (in.scope() == ScopeType.STATELESS) {
                throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @In: " + this.getAttributeMessage(name));
            }
            if (log.isDebugEnabled()) {
                log.debug("trying to inject from specified context: " + name + ", scope: " + (Object)((Object)this.scope));
            }
            if (enforceRequired || in.scope().isContextActive()) {
                result = in.scope().getContext().get(name);
            } else {
                return null;
            }
        }
        if (result == null && enforceRequired && in.required()) {
            throw new RequiredException("@In attribute requires non-null value: " + this.getAttributeMessage(name));
        }
        return result;
    }

    private Object getInstanceInAllNamespaces(String name, boolean create) {
        Namespace namespace;
        Namespace namespace2;
        Iterator<Namespace> i$;
        Object result = Component.getInstance(name, create);
        if (result == null) {
            i$ = this.getImports().iterator();
            while (i$.hasNext() && (result = (namespace2 = i$.next()).getComponentInstance(name, create)) == null) {
            }
        }
        if (result == null) {
            i$ = Init.instance().getGlobalImports().iterator();
            while (i$.hasNext() && (result = (namespace2 = i$.next()).getComponentInstance(name, create)) == null) {
            }
        }
        if (result == null && (namespace = this.getNamespace()) != null) {
            result = namespace.getComponentInstance(name, create);
        }
        return result;
    }

    private String getAttributeMessage(String attributeName) {
        return this.getName() + '.' + attributeName;
    }

    private static String toName(String name, Method method) {
        if (name == null || name.length() == 0) {
            name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        return name;
    }

    private static String toName(String name, Field field) {
        if (name == null || name.length() == 0) {
            name = field.getName();
        }
        return name;
    }

    public String toString() {
        return "Component(" + this.name + ")";
    }

    public static Class<ProxyObject> createProxyFactory(ComponentType type, Class beanClass, Collection<Class> businessInterfaces) {
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        interfaces.add(Instance.class);
        interfaces.add(Proxy.class);
        if (type.isSessionBean()) {
            interfaces.addAll(businessInterfaces);
        } else {
            interfaces.add(HttpSessionActivationListener.class);
            interfaces.add(Mutable.class);
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(type == ComponentType.JAVA_BEAN ? beanClass : Object.class);
        factory.setInterfaces(interfaces.toArray(new Class[0]));
        factory.setFilter(FINALIZE_FILTER);
        return factory.createClass();
    }

    public boolean isInterceptionEnabled() {
        return this.interceptionEnabled;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public boolean isLifecycleMethod(Method method) {
        return method == null || this.lifecycleMethods.contains(method);
    }

    public boolean isConversationManagementMethod(Method method) {
        return method != null && this.conversationManagementMethods.contains(method);
    }

    public List<BijectedAttribute> getPersistenceContextAttributes() {
        return this.pcAttributes;
    }

    public Collection<Namespace> getImports() {
        return this.imports;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isPerNestedConversation() {
        return this.perNestedConversation;
    }

    public boolean hasConversationManagementMethods() {
        return !this.conversationManagementMethods.isEmpty();
    }

    public boolean isSecure() {
        return this.secure;
    }

    static final class BijectedField<T extends Annotation>
    implements BijectedAttribute<T> {
        private final String name;
        private final Field field;
        private final T annotation;
        final /* synthetic */ Component this$0;

        private BijectedField(String name, Field field, T annotation) {
            this.this$0 = var1_1;
            this.name = name;
            this.field = field;
            this.annotation = annotation;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public T getAnnotation() {
            return this.annotation;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public void set(Object bean, Object value) {
            this.this$0.setFieldValue(bean, this.field, this.name, value);
        }

        @Override
        public Object get(Object bean) {
            return this.this$0.getFieldValue(bean, this.field, this.name);
        }

        public String toString() {
            return "BijectedField(" + this.name + ')';
        }
    }

    static final class BijectedProperty<T extends Annotation>
    implements BijectedAttribute<T> {
        private BijectedMethod<T> getter;
        private BijectedMethod<T> setter;
        final /* synthetic */ Component this$0;

        public BijectedProperty(String name, Method getter, Method setter, T annotation) {
            this.this$0 = var1_1;
            this.getter = new BijectedMethod(var1_1, name, getter, (Annotation)annotation);
            this.setter = new BijectedMethod(var1_1, name, setter, (Annotation)annotation);
        }

        public BijectedProperty(String name, Method getter, T annotation) {
            this.this$0 = var1_1;
            this.getter = new BijectedMethod(var1_1, name, getter, (Annotation)annotation);
            try {
                Method setterMethod = Reflections.getSetterMethod(getter.getDeclaringClass(), name);
                this.setter = new BijectedMethod(var1_1, name, setterMethod, (Annotation)annotation);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }

        @Override
        public Object get(Object bean) {
            return this.getter.get(bean);
        }

        @Override
        public T getAnnotation() {
            return this.getter.getAnnotation();
        }

        @Override
        public String getName() {
            return this.getter.getName();
        }

        @Override
        public Class getType() {
            return this.getter.getType();
        }

        @Override
        public void set(Object bean, Object value) {
            if (this.setter == null) {
                throw new IllegalArgumentException("Component must have a setter for " + this.this$0.name);
            }
            this.setter.set(bean, value);
        }
    }

    static final class BijectedMethod<T extends Annotation>
    implements BijectedAttribute<T> {
        private final String name;
        private final Method method;
        private final T annotation;
        final /* synthetic */ Component this$0;

        private BijectedMethod(String name, Method method, T annotation) {
            this.this$0 = var1_1;
            this.name = name;
            this.method = method;
            this.annotation = annotation;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public T getAnnotation() {
            return this.annotation;
        }

        @Override
        public void set(Object bean, Object value) {
            this.this$0.setPropertyValue(bean, this.method, this.name, value);
        }

        @Override
        public Object get(Object bean) {
            return this.this$0.getPropertyValue(bean, this.method, this.name);
        }

        @Override
        public Class getType() {
            return this.method.getParameterTypes()[0];
        }

        public String toString() {
            return "BijectedMethod(" + this.name + ')';
        }
    }

    public static interface BijectedAttribute<T extends Annotation> {
        public String getName();

        public T getAnnotation();

        public Class getType();

        public void set(Object var1, Object var2);

        public Object get(Object var1);
    }

    static class MapInitialValue
    implements InitialValue {
        private Map<InitialValue, InitialValue> initialValues;
        private Class elementType;
        private Class keyType;
        private Class collectionClass;

        public MapInitialValue(Conversions.PropertyValue propertyValue, Class collectionClass, Type collectionType) {
            Map<String, String> expressions = propertyValue.getKeyedValues();
            this.initialValues = new LinkedHashMap<InitialValue, InitialValue>(expressions.size());
            this.elementType = Reflections.getCollectionElementType(collectionType);
            this.keyType = Reflections.getMapKeyType(collectionType);
            this.collectionClass = propertyValue.getType() != null ? propertyValue.getType() : collectionClass;
            for (Map.Entry<String, String> me : expressions.entrySet()) {
                Conversions.FlatPropertyValue keyValue = new Conversions.FlatPropertyValue(me.getKey());
                Conversions.FlatPropertyValue elementValue = new Conversions.FlatPropertyValue(me.getValue());
                this.initialValues.put(Component.getInitialValue(keyValue, this.keyType, this.keyType), Component.getInitialValue(elementValue, this.elementType, this.elementType));
            }
        }

        @Override
        public Object getValue(Class type) {
            Map<Object, Object> result;
            if (Modifier.isAbstract(this.collectionClass.getModifiers()) || Modifier.isInterface(this.collectionClass.getModifiers())) {
                result = this.collectionClass == SortedMap.class ? new TreeMap() : new LinkedHashMap(this.initialValues.size());
            } else {
                try {
                    result = (Map)this.collectionClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instantiate a map of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot cast " + this.collectionClass + " to java.util.Map");
                }
                catch (java.lang.InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate a map of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
            }
            for (Map.Entry<InitialValue, InitialValue> me : this.initialValues.entrySet()) {
                result.put(me.getKey().getValue(this.keyType), me.getValue().getValue(this.elementType));
            }
            return result;
        }

        public String toString() {
            return "MapInitialValue(" + this.keyType.getSimpleName() + "," + this.elementType.getSimpleName() + ")";
        }
    }

    static class ListInitialValue
    implements InitialValue {
        private InitialValue[] initialValues;
        private Class elementType;
        private boolean isArray;
        private Class collectionClass;

        public ListInitialValue(Conversions.PropertyValue propertyValue, Class collectionClass, Type collectionType) {
            String[] expressions = propertyValue.getMultiValues();
            this.initialValues = new InitialValue[expressions.length];
            this.isArray = collectionClass.isArray();
            this.elementType = this.isArray ? collectionClass.getComponentType() : Reflections.getCollectionElementType(collectionType);
            this.collectionClass = propertyValue.getType() != null ? propertyValue.getType() : collectionClass;
            for (int i = 0; i < expressions.length; ++i) {
                Conversions.FlatPropertyValue elementValue = new Conversions.FlatPropertyValue(expressions[i]);
                this.initialValues[i] = Component.getInitialValue(elementValue, this.elementType, this.elementType);
            }
        }

        @Override
        public Object getValue(Class type) {
            List<Object> list;
            if (this.isArray) {
                Object array = Array.newInstance(this.elementType, this.initialValues.length);
                for (int i = 0; i < this.initialValues.length; ++i) {
                    Array.set(array, i, this.initialValues[i].getValue(this.elementType));
                }
                return array;
            }
            if (Modifier.isAbstract(this.collectionClass.getModifiers()) || Modifier.isInterface(this.collectionClass.getModifiers())) {
                list = new ArrayList(this.initialValues.length);
            } else {
                try {
                    list = (List)this.collectionClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instantiate a list of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot cast " + this.collectionClass + " to java.util.List");
                }
                catch (java.lang.InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate a list of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
            }
            for (InitialValue iv : this.initialValues) {
                list.add(iv.getValue(this.elementType));
            }
            return list;
        }

        public String toString() {
            return "ListInitialValue(" + this.elementType.getSimpleName() + ")";
        }
    }

    static class SetInitialValue
    implements InitialValue {
        private InitialValue[] initialValues;
        private Class elementType;
        private Class collectionClass;

        public SetInitialValue(Conversions.PropertyValue propertyValue, Class collectionClass, Type collectionType) {
            String[] expressions = propertyValue.getMultiValues();
            this.initialValues = new InitialValue[expressions.length];
            this.elementType = Reflections.getCollectionElementType(collectionType);
            this.collectionClass = propertyValue.getType() != null ? propertyValue.getType() : collectionClass;
            for (int i = 0; i < expressions.length; ++i) {
                Conversions.FlatPropertyValue elementValue = new Conversions.FlatPropertyValue(expressions[i]);
                this.initialValues[i] = Component.getInitialValue(elementValue, this.elementType, this.elementType);
            }
        }

        @Override
        public Object getValue(Class type) {
            Set<Object> set;
            if (Modifier.isAbstract(this.collectionClass.getModifiers()) || Modifier.isInterface(this.collectionClass.getModifiers())) {
                set = this.collectionClass == SortedSet.class ? new TreeSet() : new LinkedHashSet(this.initialValues.length);
            } else {
                try {
                    set = (Set)this.collectionClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instantiate a set of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Cannot cast " + this.collectionClass + " to java.util.Set");
                }
                catch (java.lang.InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate a set of type " + this.collectionClass + "; try specifying type type in components.xml");
                }
            }
            for (InitialValue iv : this.initialValues) {
                set.add(iv.getValue(this.elementType));
            }
            return set;
        }

        public String toString() {
            return "SetInitialValue(" + this.elementType.getSimpleName() + ")";
        }
    }

    static class ELInitialValue
    implements InitialValue {
        private String expression;
        private Conversions.Converter converter;
        private Type parameterType;

        public ELInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
            this.expression = propertyValue.getSingleValue();
            this.parameterType = parameterType;
            try {
                this.converter = Conversions.getConverter(parameterClass);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }

        @Override
        public Object getValue(Class type) {
            Serializable value = type.equals(Expressions.ValueExpression.class) ? this.createValueExpression() : (type.equals(Expressions.MethodExpression.class) ? this.createMethodExpression() : this.createValueExpression().getValue());
            if (this.converter != null && value instanceof String) {
                return this.converter.toObject(new Conversions.FlatPropertyValue((String)((Object)value)), this.parameterType);
            }
            if (this.converter != null && value instanceof String[]) {
                return this.converter.toObject(new Conversions.MultiPropertyValue((String[])value, null), this.parameterType);
            }
            return value;
        }

        private Expressions.ValueExpression createValueExpression() {
            return Expressions.instance().createValueExpression(this.expression);
        }

        private Expressions.MethodExpression createMethodExpression() {
            return Expressions.instance().createMethodExpression(this.expression);
        }

        public String toString() {
            return "ELInitialValue(" + this.expression + ")";
        }
    }

    static class ConstantInitialValue
    implements InitialValue {
        private Object value;

        public ConstantInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
            this.value = Conversions.getConverter(parameterClass).toObject(propertyValue, parameterType);
        }

        @Override
        public Object getValue(Class type) {
            return this.value;
        }

        public String toString() {
            return "ConstantInitialValue(" + this.value + ")";
        }
    }

    static interface InitialValue {
        public Object getValue(Class var1);
    }
}

