/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.ReadOnly;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.RootInterceptor;
import org.jboss.seam.intercept.RootInvocationContext;

public class JavaBeanInterceptor
extends RootInterceptor
implements MethodHandler {
    private static final long serialVersionUID = -771725005103740533L;
    private final Object bean;
    private final Class beanClass;
    private transient boolean dirty;

    public JavaBeanInterceptor(Object bean, Component component) {
        super(InterceptorType.ANY);
        this.bean = bean;
        this.beanClass = component.getBeanClass();
        this.init(component);
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] params) throws Throwable {
        if (params != null) {
            String methodName;
            if (params.length == 0) {
                methodName = method.getName();
                if ("finalize".equals(methodName)) {
                    return proceed.invoke(proxy, params);
                }
                if ("writeReplace".equals(methodName)) {
                    return this;
                }
                if ("clearDirty".equals(methodName) && !(this.bean instanceof Mutable)) {
                    boolean result = this.dirty;
                    this.dirty = false;
                    return result;
                }
                if ("getComponent".equals(methodName)) {
                    return this.getComponent();
                }
            } else if (params.length == 1 && params[0] instanceof HttpSessionEvent) {
                methodName = method.getName();
                if ("sessionDidActivate".equals(methodName)) {
                    this.callPostActivate();
                    return this.bean instanceof HttpSessionActivationListener ? method.invoke(this.bean, params) : null;
                }
                if ("sessionWillPassivate".equals(methodName)) {
                    this.callPrePassivate();
                    return this.bean instanceof HttpSessionActivationListener ? method.invoke(this.bean, params) : null;
                }
            }
        }
        if (this.markDirty(method)) {
            this.dirty = true;
        }
        if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && params[0] == proxy) {
            return this.interceptInvocation(method, new Object[]{this.bean});
        }
        Object result = this.interceptInvocation(method, params);
        return result == this.bean ? proxy : result;
    }

    private boolean markDirty(Method method) {
        return !this.getComponent().getBeanClass().isAnnotationPresent(ReadOnly.class) && !method.isAnnotationPresent(ReadOnly.class);
    }

    public void postConstruct() {
        super.postConstruct(this.bean);
        this.callPostConstruct();
    }

    private void callPostConstruct() {
        final Component component = this.getComponent();
        if (!component.hasPostConstructMethod()) {
            return;
        }
        RootInvocationContext context = new RootInvocationContext(this.bean, component.getPostConstructMethod(), new Object[0]){

            @Override
            public Object proceed() throws Exception {
                component.callPostConstructMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.POST_CONSTRUCT);
    }

    private void callPrePassivate() {
        final Component component = this.getComponent();
        if (!component.hasPrePassivateMethod()) {
            return;
        }
        RootInvocationContext context = new RootInvocationContext(this.bean, component.getPrePassivateMethod(), new Object[0]){

            @Override
            public Object proceed() throws Exception {
                component.callPrePassivateMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.PRE_PASSIVATE);
    }

    private void callPostActivate() {
        final Component component = this.getComponent();
        if (!component.hasPostActivateMethod()) {
            return;
        }
        RootInvocationContext context = new RootInvocationContext(this.bean, component.getPostActivateMethod(), new Object[0]){

            @Override
            public Object proceed() throws Exception {
                component.callPostActivateMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.POST_ACTIVATE);
    }

    private Object interceptInvocation(Method method, Object[] params) throws Exception {
        return this.invoke(new RootInvocationContext(this.bean, method, params), EventType.AROUND_INVOKE);
    }

    Object readResolve() {
        Component comp = null;
        try {
            comp = this.getComponent();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            if (comp == null) {
                ProxyObject proxy = Component.createProxyFactory(ComponentType.JAVA_BEAN, this.beanClass, Component.getBusinessInterfaces(this.beanClass)).newInstance();
                proxy.setHandler((MethodHandler)this);
                return proxy;
            }
            return comp.wrap(this.bean, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

