/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.servlet.SeamResourceServlet;

public class ResourceRequestEnvironment {
    protected final AbstractSeamTest seamTest;
    protected final SeamResourceServlet resourceServlet;

    public ResourceRequestEnvironment(AbstractSeamTest seamTest) {
        this.seamTest = seamTest;
        this.resourceServlet = new SeamResourceServlet();
        try {
            this.resourceServlet.init(new ServletConfig(){

                public String getServletName() {
                    return "Seam Resource Servlet";
                }

                public ServletContext getServletContext() {
                    return ResourceRequestEnvironment.this.seamTest.servletContext;
                }

                public String getInitParameter(String s) {
                    return null;
                }

                public Enumeration getInitParameterNames() {
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getServletPath() {
        return "/seam/resource";
    }

    public Map<String, Object> getDefaultHeaders() {
        return Collections.EMPTY_MAP;
    }

    public static class ResourceRequest {
        private final ResourceRequestEnvironment environment;
        private Method httpMethod;
        private String requestPath;
        private EnhancedMockHttpServletRequest request;
        private EnhancedMockHttpServletResponse response;

        public ResourceRequest(ResourceRequestEnvironment environment, Method httpMethod, String requestPath) {
            this.environment = environment;
            this.httpMethod = httpMethod;
            this.requestPath = environment.getServletPath() + (requestPath.startsWith("/") ? requestPath : "/" + requestPath);
        }

        public void run() throws Exception {
            this.init();
            this.prepareRequest(this.request);
            this.environment.seamTest.seamFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, new FilterChain(){

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    ((ResourceRequest)ResourceRequest.this).environment.resourceServlet.service(request, response);
                }
            });
            this.environment.seamTest.seamFilter.destroy();
            this.onResponse(this.getResponse());
        }

        protected void init() {
            this.request = this.createRequest();
            this.response = this.createResponse();
            this.request.setMethod(this.httpMethod.toString());
            this.request.setRequestURI(this.requestPath);
            this.request.setServletPath(this.environment.getServletPath());
            this.request.setCookies(this.getCookies().toArray(new Cookie[this.getCookies().size()]));
            for (Map.Entry<String, Object> entry : this.environment.getDefaultHeaders().entrySet()) {
                this.request.addHeader(entry.getKey(), entry.getValue());
            }
            this.request.setUserPrincipal(new Principal(){

                @Override
                public String getName() {
                    return ResourceRequest.this.getPrincipalName();
                }
            });
            for (String role : this.getPrincipalRoles()) {
                this.request.addUserRole(role);
            }
            this.request.setSession(this.environment.seamTest.session);
        }

        protected EnhancedMockHttpServletRequest createRequest() {
            return new EnhancedMockHttpServletRequest();
        }

        protected EnhancedMockHttpServletResponse createResponse() {
            return new EnhancedMockHttpServletResponse();
        }

        protected Map<String, String> getRequestQueryParameters() {
            return Collections.EMPTY_MAP;
        }

        protected List<Cookie> getCookies() {
            return Collections.EMPTY_LIST;
        }

        protected String getPrincipalName() {
            return null;
        }

        protected Set<String> getPrincipalRoles() {
            return Collections.EMPTY_SET;
        }

        protected void prepareRequest(EnhancedMockHttpServletRequest request) {
        }

        protected void onResponse(EnhancedMockHttpServletResponse response) {
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public EnhancedMockHttpServletResponse getResponse() {
            return this.response;
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

