/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.lang.annotation.Annotation;
import javax.ejb.EJBContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;

public class EJB {
    public static String ejbContextName = "java:comp.ejb3/EJBContext";
    public static final String STANDARD_EJB_CONTEXT_NAME = "java:comp/EJBContext";
    public static final Class<Annotation> STATELESS = EJB.classForName("javax.ejb.Stateless");
    public static final Class<Annotation> STATEFUL = EJB.classForName("javax.ejb.Stateful");
    public static final Class<Annotation> SINGLETON = EJB.classForName("javax.ejb.Singleton");
    public static final Class<Annotation> MESSAGE_DRIVEN = EJB.classForName("javax.ejb.MessageDriven");
    public static final Class<Annotation> PRE_PASSIVATE;
    public static final Class<Annotation> POST_ACTIVATE;
    public static final Class<Annotation> PRE_DESTROY;
    public static final Class<Annotation> POST_CONSTRUCT;
    public static final Class<Annotation> REMOTE;
    public static final Class<Annotation> REMOVE;
    public static final Class<Annotation> LOCAL;
    public static final Class<Annotation> APPLICATION_EXCEPTION;
    public static final Class<Annotation> PERSISTENCE_CONTEXT;
    public static final Class<Annotation> INTERCEPTORS;
    public static final Class<Annotation> AROUND_INVOKE;
    public static final Class<Annotation> EJB_EXCEPTION;
    public static final boolean INVOCATION_CONTEXT_AVAILABLE;

    private static Class classForName(String name) {
        try {
            return Reflections.classForName(name);
        }
        catch (ClassNotFoundException cnfe) {
            return Dummy.class;
        }
    }

    public static String name(Annotation annotation) {
        return (String)Reflections.invokeAndWrap(Reflections.getMethod(annotation, "name"), annotation, new Object[0]);
    }

    public static Class[] value(Annotation annotation) {
        return (Class[])Reflections.invokeAndWrap(Reflections.getMethod(annotation, "value"), annotation, new Object[0]);
    }

    public static boolean rollback(Annotation annotation) {
        return (Boolean)Reflections.invokeAndWrap(Reflections.getMethod(annotation, "rollback"), annotation, new Object[0]);
    }

    public static EJBContext getEJBContext() throws NamingException {
        try {
            return (EJBContext)Naming.getInitialContext().lookup(ejbContextName);
        }
        catch (NameNotFoundException nnfe) {
            return (EJBContext)Naming.getInitialContext().lookup(STANDARD_EJB_CONTEXT_NAME);
        }
    }

    protected static String getEjbContextName() {
        return ejbContextName;
    }

    protected static void setEjbContextName(String ejbContextName) {
        EJB.ejbContextName = ejbContextName;
    }

    static {
        APPLICATION_EXCEPTION = EJB.classForName("javax.ejb.ApplicationException");
        PERSISTENCE_CONTEXT = EJB.classForName("javax.persistence.PersistenceContext");
        REMOVE = EJB.classForName("javax.ejb.Remove");
        REMOTE = EJB.classForName("javax.ejb.Remote");
        LOCAL = EJB.classForName("javax.ejb.Local");
        PRE_PASSIVATE = EJB.classForName("javax.ejb.PrePassivate");
        POST_ACTIVATE = EJB.classForName("javax.ejb.PostActivate");
        PRE_DESTROY = EJB.classForName("javax.annotation.PreDestroy");
        POST_CONSTRUCT = EJB.classForName("javax.annotation.PostConstruct");
        INTERCEPTORS = EJB.classForName("javax.interceptor.Interceptors");
        AROUND_INVOKE = EJB.classForName("javax.interceptor.AroundInvoke");
        EJB_EXCEPTION = EJB.classForName("javax.ejb.EJBException");
        INVOCATION_CONTEXT_AVAILABLE = !EJB.classForName("javax.interceptor.InvocationContext").equals(Dummy.class);
    }

    public static @interface Dummy {
    }
}

