/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.seam.Component;
import org.jboss.seam.Namespace;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.bpm.BusinessProcessInterceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.core.ConversationInterceptor;
import org.jboss.seam.core.ConversationalInterceptor;
import org.jboss.seam.core.EventInterceptor;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.MethodContextInterceptor;
import org.jboss.seam.core.SynchronizationInterceptor;
import org.jboss.seam.ejb.RemoveInterceptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.EntityManagerProxyInterceptor;
import org.jboss.seam.persistence.HibernateSessionProxyInterceptor;
import org.jboss.seam.persistence.ManagedEntityInterceptor;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SecurityInterceptor;
import org.jboss.seam.transaction.RollbackInterceptor;
import org.jboss.seam.transaction.TransactionInterceptor;
import org.jboss.seam.util.Resources;
import org.jboss.seam.webservice.WSSecurityInterceptor;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Name(value="org.jboss.seam.core.init")
@Install(value=false, precedence=0)
public class Init {
    public static List<String> DEFAULT_INTERCEPTORS = new ArrayList<String>(Arrays.asList(SynchronizationInterceptor.class.getName(), AsynchronousInterceptor.class.getName(), RemoveInterceptor.class.getName(), HibernateSessionProxyInterceptor.class.getName(), EntityManagerProxyInterceptor.class.getName(), MethodContextInterceptor.class.getName(), EventInterceptor.class.getName(), ConversationalInterceptor.class.getName(), BusinessProcessInterceptor.class.getName(), ConversationInterceptor.class.getName(), BijectionInterceptor.class.getName(), RollbackInterceptor.class.getName(), TransactionInterceptor.class.getName(), WSSecurityInterceptor.class.getName(), SecurityInterceptor.class.getName()));
    private LogProvider log = Logging.getLogProvider(Init.class);
    private Namespace rootNamespace = new Namespace(null);
    private Collection<Namespace> globalImports = new ArrayList<Namespace>();
    private boolean jbpmInstalled;
    private String jndiPattern;
    private boolean debug;
    private boolean myFacesLifecycleBug;
    private boolean transactionManagementEnabled = true;
    private boolean distributable = false;
    private List<String> interceptors = new ArrayList<String>(DEFAULT_INTERCEPTORS);
    private Map<String, List<ObserverMethod>> observerMethods = new HashMap<String, List<ObserverMethod>>();
    private Map<String, List<ObserverMethodExpression>> observerMethodBindings = new HashMap<String, List<ObserverMethodExpression>>();
    private Map<String, FactoryMethod> factories = new HashMap<String, FactoryMethod>();
    private Map<String, FactoryExpression> factoryMethodExpressions = new HashMap<String, FactoryExpression>();
    private Map<String, FactoryExpression> factoryValueExpressions = new HashMap<String, FactoryExpression>();
    private Set<String> autocreateVariables = new HashSet<String>();
    private Set<String> installedFilters = new HashSet<String>();
    private Set<String> resourceProviders = new HashSet<String>();
    private Set<String> permissionResolvers = new HashSet<String>();
    private Set<String> hotDeployableComponents = new HashSet<String>();
    private Map<String, String> converters = new HashMap<String, String>();
    private Map<String, String> validators = new HashMap<String, String>();
    private Map<Class, String> convertersByClass = new HashMap<Class, String>();
    private long timestamp;
    private long warTimestamp;
    private File[] hotDeployPaths;

    public static Init instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        Init init = (Init)Contexts.getApplicationContext().get(Init.class);
        return init;
    }

    public FactoryMethod getFactory(String variable) {
        return this.factories.get(variable);
    }

    public FactoryExpression getFactoryMethodExpression(String variable) {
        return this.factoryMethodExpressions.get(variable);
    }

    public FactoryExpression getFactoryValueExpression(String variable) {
        return this.factoryValueExpressions.get(variable);
    }

    private void checkDuplicateFactory(String variable) {
        if (this.factories.containsKey(variable)) {
            throw new IllegalStateException("duplicate factory for: " + variable + " (duplicate is specified in a component)");
        }
        this.checkDuplicateFactoryExpressions(variable);
    }

    private void checkDuplicateFactoryExpressions(String variable) {
        if (this.factoryMethodExpressions.containsKey(variable) || this.factoryValueExpressions.containsKey(variable)) {
            throw new IllegalStateException("duplicate factory for: " + variable + " (duplicate is specified in components.xml)");
        }
    }

    private void checkDuplicateFactory(String variable, Component component) {
        if (this.factories.containsKey(variable)) {
            String otherComponentName = this.factories.get(variable).getComponent().getName();
            String componentName = component.getName();
            if (componentName != null && !componentName.equals(otherComponentName)) {
                throw new IllegalStateException("duplicate factory for: " + variable + " (duplicates are specified in " + componentName + " and " + otherComponentName + ")");
            }
        }
        this.checkDuplicateFactoryExpressions(variable);
    }

    public Namespace initNamespaceForName(String name, boolean isComponent) {
        Namespace namespace = this.getRootNamespace();
        StringTokenizer tokens = new StringTokenizer(name, ".");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!tokens.hasMoreTokens() && isComponent) continue;
            namespace = namespace.getOrCreateChild(token);
        }
        return namespace;
    }

    public void addFactoryMethod(String variable, Method method, Component component) {
        this.checkDuplicateFactory(variable, component);
        this.factories.put(variable, new FactoryMethod(method, component));
        this.initNamespaceForName(variable, true);
    }

    public void addFactoryMethodExpression(String variable, String methodBindingExpression, ScopeType scope) {
        this.checkDuplicateFactory(variable);
        this.factoryMethodExpressions.put(variable, new FactoryExpression(methodBindingExpression, scope));
        this.initNamespaceForName(variable, true);
    }

    public void addFactoryValueExpression(String variable, String valueBindingExpression, ScopeType scope) {
        this.checkDuplicateFactory(variable);
        this.factoryValueExpressions.put(variable, new FactoryExpression(valueBindingExpression, scope));
        this.initNamespaceForName(variable, true);
    }

    public List<ObserverMethod> getObserverMethods(String eventType) {
        return this.observerMethods.get(eventType);
    }

    public List<ObserverMethodExpression> getObserverMethodExpressions(String eventType) {
        return this.observerMethodBindings.get(eventType);
    }

    public void addObserverMethod(String eventType, Method method, Component component, boolean create) {
        ObserverMethod observerMethod;
        List<ObserverMethod> observerList = this.observerMethods.get(eventType);
        if (observerList == null) {
            observerList = new ArrayList<ObserverMethod>();
            this.observerMethods.put(eventType, observerList);
        }
        if (!observerList.contains(observerMethod = new ObserverMethod(method, component, create))) {
            observerList.add(observerMethod);
        }
    }

    public void addObserverMethodExpression(String eventType, Expressions.MethodExpression methodBinding) {
        List<ObserverMethodExpression> observerList = this.observerMethodBindings.get(eventType);
        if (observerList == null) {
            observerList = new ArrayList<ObserverMethodExpression>();
            this.observerMethodBindings.put(eventType, observerList);
        }
        observerList.add(new ObserverMethodExpression(methodBinding));
    }

    public void removeObserverMethods(Component component) {
        for (String eventType : this.observerMethods.keySet()) {
            ArrayList<ObserverMethod> observerMethodsToRemove = new ArrayList<ObserverMethod>();
            for (ObserverMethod observerMethod : this.observerMethods.get(eventType)) {
                if (!observerMethod.getComponent().equals(component)) continue;
                observerMethodsToRemove.add(observerMethod);
            }
            this.observerMethods.get(eventType).removeAll(observerMethodsToRemove);
        }
    }

    public boolean isJbpmInstalled() {
        return this.jbpmInstalled;
    }

    public String getJndiPattern() {
        return this.jndiPattern;
    }

    public void setJndiPattern(String jndiPattern) {
        this.jndiPattern = jndiPattern;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebugPageAvailable() {
        return this.debug && Resources.getResource("META-INF/resources/debug.xhtml", null) != null;
    }

    public boolean isMyFacesLifecycleBug() {
        return this.myFacesLifecycleBug;
    }

    public void setMyFacesLifecycleBug(boolean myFacesLifecycleBugExists) {
        this.myFacesLifecycleBug = myFacesLifecycleBugExists;
    }

    public void setJbpmInstalled(boolean jbpmInstalled) {
        this.jbpmInstalled = jbpmInstalled;
    }

    public boolean isAutocreateVariable(String name) {
        return this.autocreateVariables.contains(name);
    }

    public void addAutocreateVariable(String name) {
        this.autocreateVariables.add(name);
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    public void importNamespace(String namespaceName) {
        Namespace namespace = this.getRootNamespace();
        StringTokenizer tokens = new StringTokenizer(namespaceName, ".");
        while (tokens.hasMoreTokens()) {
            namespace = namespace.getOrCreateChild(tokens.nextToken());
        }
        this.globalImports.add(namespace);
    }

    public void addInstalledFilter(String name) {
        this.installedFilters.add(name);
    }

    public Set<String> getInstalledFilters() {
        return this.installedFilters;
    }

    public void addResourceProvider(String name) {
        this.resourceProviders.add(name);
    }

    public Set<String> getResourceProviders() {
        return this.resourceProviders;
    }

    public void addPermissionResolver(String name) {
        this.permissionResolvers.add(name);
    }

    public Set<String> getPermissionResolvers() {
        return this.permissionResolvers;
    }

    public Set<String> getHotDeployableComponents() {
        return this.hotDeployableComponents;
    }

    public void addHotDeployableComponent(String name) {
        this.hotDeployableComponents.add(name);
    }

    public Map<String, String> getConverters() {
        return this.converters;
    }

    public Map<Class, String> getConvertersByClass() {
        return this.convertersByClass;
    }

    public Map<String, String> getValidators() {
        return this.validators;
    }

    public boolean hasHotDeployableComponents() {
        return this.hotDeployPaths != null;
    }

    public File[] getHotDeployPaths() {
        return this.hotDeployPaths;
    }

    public void setHotDeployPaths(File[] hotDeployJars) {
        this.hotDeployPaths = hotDeployJars;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getWarTimestamp() {
        return this.warTimestamp;
    }

    public void setWarTimestamp(long warTimestamp) {
        this.warTimestamp = warTimestamp;
    }

    public boolean isTransactionManagementEnabled() {
        return this.transactionManagementEnabled;
    }

    public void setTransactionManagementEnabled(boolean transactionManagementEnabled) {
        this.transactionManagementEnabled = transactionManagementEnabled;
    }

    public boolean isSecurityEnabled() {
        return Identity.isSecurityEnabled();
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        Identity.setSecurityEnabled(securityEnabled);
    }

    public Collection<Namespace> getGlobalImports() {
        return this.globalImports;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void checkDefaultInterceptors() {
        for (String defaultInterceptor : DEFAULT_INTERCEPTORS) {
            if (this.interceptors.contains(defaultInterceptor)) continue;
            this.log.warn("The built-in interceptor " + defaultInterceptor + " is missing. This application may not function as expected");
        }
        if (this.distributable && !this.interceptors.contains(ManagedEntityInterceptor.class.getName())) {
            this.interceptors.add(ManagedEntityInterceptor.class.getName());
        }
    }

    public static class ObserverMethodExpression {
        private Expressions.MethodExpression methodBinding;

        ObserverMethodExpression(Expressions.MethodExpression method) {
            this.methodBinding = method;
        }

        public Expressions.MethodExpression getMethodBinding() {
            return this.methodBinding;
        }

        public String toString() {
            return "ObserverMethodBinding(" + this.methodBinding + ')';
        }
    }

    public static class ObserverMethod {
        private Method method;
        private Component component;
        private boolean create;

        ObserverMethod(Method method, Component component, boolean create) {
            this.method = method;
            this.component = component;
            this.create = create;
        }

        public Component getComponent() {
            return this.component;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isCreate() {
            return this.create;
        }

        public String toString() {
            return "ObserverMethod(" + this.method + ')';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObserverMethod)) {
                return false;
            }
            ObserverMethod other = (ObserverMethod)obj;
            return this.component.equals(other.component) && Arrays.equals(this.method.getParameterTypes(), other.method.getParameterTypes()) && this.method.getName().equals(other.getMethod().getName());
        }
    }

    public static class FactoryExpression {
        private String expression;
        private ScopeType scope;

        FactoryExpression(String expression, ScopeType scope) {
            this.expression = expression;
            this.scope = scope;
        }

        public Expressions.MethodExpression getMethodBinding() {
            return Expressions.instance().createMethodExpression(this.expression);
        }

        public Expressions.ValueExpression getValueBinding() {
            return Expressions.instance().createValueExpression(this.expression);
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public String toString() {
            return "FactoryBinding(" + this.expression + ')';
        }
    }

    public static class FactoryMethod {
        private Method method;
        private Component component;
        private ScopeType scope;

        FactoryMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
            this.scope = method.getAnnotation(Factory.class).scope();
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public Component getComponent() {
            return this.component;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            return "FactoryMethod(" + this.method + ')';
        }
    }
}

