/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.jboss.seam.mock.DelegatingServletInputStream;
import org.jboss.seam.mock.HeaderValueHolder;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockRequestDispatcher;
import org.jboss.seam.mock.MockServletContext;

public class EnhancedMockHttpServletRequest
implements HttpServletRequest {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private boolean active = true;
    private final Hashtable attributes = new Hashtable();
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private final Map parameters = new LinkedHashMap(16);
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final Vector locales = new Vector();
    private boolean secure = false;
    private final ServletContext servletContext;
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    private String authType;
    private Cookie[] cookies;
    private final Hashtable headers = new Hashtable();
    private String method;
    private String pathInfo;
    private String contextPath = "";
    private String queryString;
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private String remoteUser;
    private Set<String> userRoles = new HashSet<String>();
    private Principal userPrincipal;
    private String requestURI;
    private String servletPath = "";
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;

    public EnhancedMockHttpServletRequest() {
        this(null, "", "");
    }

    public EnhancedMockHttpServletRequest(String method, String requestURI) {
        this(null, method, requestURI);
    }

    public EnhancedMockHttpServletRequest(ServletContext servletContext) {
        this(servletContext, "", "");
    }

    public EnhancedMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
        this.addHeader("Accept", new String[0]);
    }

    public EnhancedMockHttpServletRequest(HttpSession session) {
        this(session, null, new HashSet<String>());
    }

    public EnhancedMockHttpServletRequest(HttpSession session, String principalName, Set<String> principalRoles) {
        this(session, principalName, principalRoles, new Cookie[0], null);
    }

    public EnhancedMockHttpServletRequest(HttpSession session, final String principalName, Set<String> principalRoles, Cookie[] cookies, String method) {
        this(null, method, "");
        this.session = session;
        this.userPrincipal = principalName == null ? null : new Principal(){

            @Override
            public String getName() {
                return principalName;
            }
        };
        this.userRoles = principalRoles;
        this.cookies = cookies;
        this.addHeader("Accept", new String[0]);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void close() {
        this.active = false;
    }

    public void invalidate() {
        this.close();
        this.clearAttributes();
    }

    protected void checkActive() throws IllegalStateException {
        if (!this.active) {
            throw new IllegalStateException("Request is not active anymore");
        }
    }

    public Object getAttribute(String name) {
        this.checkActive();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.checkActive();
        return this.attributes.keys();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public void setParameters(Map params) {
        for (Object key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.setParameter((String)key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.setParameter((String)key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        String[] oldArr = (String[])this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void addParameters(Map params) {
        for (Object key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.addParameter((String)key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.addParameter((String)key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public String getParameter(String name) {
        String[] arr = (String[])this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void addQueryParameter(String name, String value) {
        this.addParameter(name, value);
        this.queryParameters.put(name, value);
    }

    public void removeQueryParameter(String name) {
        this.removeParameter(name);
        this.queryParameters.remove(name);
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        this.checkActive();
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.checkActive();
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addCookie(Cookie cookie) {
        this.cookies = new Cookie[this.cookies.length + 1];
        this.cookies[this.cookies.length - 1] = cookie;
    }

    public void addHeader(String name, Object value) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        if (header == null) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (value instanceof Collection) {
            header.addValues((Collection)value);
        } else if (value.getClass().isArray()) {
            header.addValueArray(value);
        } else {
            header.addValue(value);
        }
    }

    public long getDateHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is neither a Date nor a Number: " + value);
        }
        return -1L;
    }

    public String getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getValue().toString() : null;
    }

    public Map<String, String[]> getHeaders() {
        HashMap<String, String[]> headerValues = new HashMap<String, String[]>();
        Iterator i$ = this.headers.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String[] values = ((HeaderValueHolder)entry.getValue()).getValues().toArray(new String[((HeaderValueHolder)entry.getValue()).getValues().size()]);
            headerValues.put((String)entry.getKey(), values);
        }
        return headerValues;
    }

    public Enumeration getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return Collections.enumeration(header != null ? header.getValues() : Collections.EMPTY_LIST);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
        }
        return -1;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath != null ? this.contextPath : "/project";
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        if (this.getQueryParameters().size() > 0) {
            StringBuilder q = new StringBuilder(this.queryString);
            if (!this.queryString.endsWith("&")) {
                q.append("&");
            }
            for (Map.Entry<String, String> entry : this.getQueryParameters().entrySet()) {
                q.append(entry.getKey());
                q.append("=");
                q.append(entry.getValue());
                q.append("&");
            }
            if (q.toString().endsWith("&")) {
                q.deleteCharAt(q.length() - 1);
            }
            return q.toString();
        }
        return this.queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addRole(String role) {
        this.addUserRole(role);
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session != null ? session.getId() : null;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession(boolean create) {
        this.checkActive();
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.servletContext);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isAllParametersInQueryString() {
        return true;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }
}

