/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.portlet.PortletRequest;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.jboss.seam.util.IteratorEnumeration;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private HttpSession session;
    private Map<String, String[]> headers = new HashMap<String, String[]>();
    private String principalName;
    private Set<String> principalRoles;
    private Cookie[] cookies;
    private String method;
    private HttpServletRequest httpServletRequest;
    private PortletRequest portletRequest;
    private String authType;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;
    private String requestedSessionId;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private ServletInputStream inputStream;
    private String protocol;
    private String scheme;
    private String serverName;
    private int serverPort;
    private BufferedReader reader;
    private String remoteAddr;
    private String remoteHost;
    private Locale locale;
    private Enumeration locales;
    private boolean isSecure;
    private int remotePort;
    private String localName;
    private String localAddr;
    private int localPort;

    public MockHttpServletRequest(HttpSession session) {
        this(session, null, new HashSet<String>());
    }

    public MockHttpServletRequest(HttpSession session, ExternalContext externalContext) {
        this(session, null, new HashSet<String>());
        Object request = externalContext.getRequest();
        if (externalContext != null && request instanceof HttpServletRequest) {
            this.httpServletRequest = (HttpServletRequest)request;
            this.authType = this.httpServletRequest.getAuthType();
            this.pathInfo = this.httpServletRequest.getPathInfo();
            this.pathTranslated = this.httpServletRequest.getPathTranslated();
            this.contextPath = this.httpServletRequest.getContextPath();
            this.queryString = this.httpServletRequest.getQueryString();
            this.requestedSessionId = this.httpServletRequest.getRequestedSessionId();
            this.requestURI = this.httpServletRequest.getRequestURI();
            this.requestURL = this.httpServletRequest.getRequestURL();
            this.servletPath = this.httpServletRequest.getServletPath();
            this.characterEncoding = this.httpServletRequest.getCharacterEncoding();
            this.contentLength = this.httpServletRequest.getContentLength();
            this.contentType = this.httpServletRequest.getContentType();
            this.protocol = this.httpServletRequest.getProtocol();
            this.scheme = this.httpServletRequest.getScheme();
            this.serverName = this.httpServletRequest.getServerName();
            this.serverPort = this.httpServletRequest.getServerPort();
            this.remoteAddr = this.httpServletRequest.getRemoteAddr();
            this.remoteHost = this.httpServletRequest.getRemoteHost();
            this.locale = this.httpServletRequest.getLocale();
            this.locales = this.httpServletRequest.getLocales();
            this.isSecure = this.httpServletRequest.isSecure();
            this.remotePort = this.httpServletRequest.getRemotePort();
            this.localName = this.httpServletRequest.getLocalName();
            this.localAddr = this.httpServletRequest.getLocalAddr();
            this.localPort = this.httpServletRequest.getLocalPort();
        } else if (externalContext != null && request instanceof PortletRequest) {
            this.portletRequest = (PortletRequest)request;
            this.authType = this.portletRequest.getAuthType();
            this.contextPath = this.portletRequest.getContextPath();
            this.requestedSessionId = this.portletRequest.getRequestedSessionId();
            this.scheme = this.portletRequest.getScheme();
            this.serverName = this.portletRequest.getServerName();
            this.serverPort = this.portletRequest.getServerPort();
            this.locale = this.portletRequest.getLocale();
            this.locales = this.portletRequest.getLocales();
            this.isSecure = this.portletRequest.isSecure();
        }
    }

    public MockHttpServletRequest(HttpSession session, String principalName, Set<String> principalRoles) {
        this(session, principalName, principalRoles, new Cookie[0], null);
    }

    public MockHttpServletRequest(HttpSession session, String principalName, Set<String> principalRoles, Cookie[] cookies, String method) {
        this.session = session;
        this.principalName = principalName;
        this.principalRoles = principalRoles;
        this.cookies = cookies;
        this.method = method;
        this.headers.put("Accept", new String[0]);
        this.locales = new IteratorEnumeration(new ArrayList().iterator());
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String header) {
        String[] values = this.headers.get(header);
        return values == null || values.length == 0 ? null : values[0];
    }

    public Enumeration getHeaders(String header) {
        return new IteratorEnumeration(Arrays.asList((Object[])this.headers.get(header)).iterator());
    }

    public Enumeration getHeaderNames() {
        return new IteratorEnumeration(this.headers.keySet().iterator());
    }

    public int getIntHeader(String header) {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath != null ? this.contextPath : "/project";
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.principalName;
    }

    public boolean isUserInRole(String role) {
        return this.principalRoles.contains(role);
    }

    public Principal getUserPrincipal() {
        return this.principalName == null ? null : new Principal(){

            @Override
            public String getName() {
                return MockHttpServletRequest.this.principalName;
            }
        };
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI != null ? this.requestURI : "http://localhost:8080/myproject/page.seam";
    }

    public StringBuffer getRequestURL() {
        return this.requestURL != null ? this.requestURL : new StringBuffer(this.getRequestURI());
    }

    public String getServletPath() {
        return this.servletPath != null ? this.servletPath : "/page.seam";
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String att) {
        return this.attributes.get(att);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getParameter(String param) {
        String[] values = this.parameters.get(param);
        return values == null || values.length == 0 ? null : values[0];
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String param) {
        return this.parameters.get(param);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String att, Object value) {
        if (value == null) {
            this.attributes.remove(value);
        } else {
            this.attributes.put(att, value);
        }
    }

    public void removeAttribute(String att) {
        this.attributes.remove(att);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        return this.locales;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.getRequestDispatcher(path);
        }
        return null;
    }

    public String getRealPath(String path) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.getRealPath(path);
        }
        return null;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }
}

