/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.security.permission.PermissionResolver;
import org.jboss.seam.security.permission.ResolverChain;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.security.permissionMapper")
@Install(precedence=0)
@BypassInterceptors
@Startup
public class PermissionMapper
implements Serializable {
    public static final String DEFAULT_RESOLVER_CHAIN_CREATED = "org.jboss.seam.security.defaultResolverChainCreated";
    private Map<Class, Map<String, String>> resolverChains = new HashMap<Class, Map<String, String>>();
    private String defaultResolverChain;
    private static final String DEFAULT_RESOLVER_CHAIN = "org.jboss.seam.security.defaultResolverChain";

    private ResolverChain getResolverChain(Object target, String action) {
        Map<String, String> chains;
        Class targetClass = null;
        if (target instanceof Class) {
            targetClass = (Class)target;
        }
        if (targetClass != null && (chains = this.resolverChains.get(target)) != null && chains.containsKey(action)) {
            return (ResolverChain)Component.getInstance(chains.get(action), true);
        }
        if (this.defaultResolverChain != null && !"".equals(this.defaultResolverChain)) {
            return (ResolverChain)Component.getInstance(this.defaultResolverChain, true);
        }
        return this.createDefaultResolverChain();
    }

    public boolean resolvePermission(Object target, String action) {
        ResolverChain chain = this.getResolverChain(target, action);
        for (PermissionResolver resolver : chain.getResolvers()) {
            if (!resolver.hasPermission(target, action)) continue;
            return true;
        }
        return false;
    }

    public void filterByPermission(Collection collection, String action) {
        boolean homogenous = true;
        Class<?> targetClass = null;
        for (Object target : collection) {
            if (targetClass == null) {
                targetClass = target.getClass();
            }
            if (targetClass.equals(target.getClass())) continue;
            homogenous = false;
            break;
        }
        if (homogenous) {
            HashSet<Object> denied = new HashSet<Object>(collection);
            ResolverChain chain = this.getResolverChain(targetClass, action);
            for (PermissionResolver permissionResolver : chain.getResolvers()) {
                permissionResolver.filterSetByAction(denied, action);
            }
            for (PermissionResolver permissionResolver : denied) {
                collection.remove(permissionResolver);
            }
        } else {
            HashMap deniedByClass = new HashMap();
            for (Object obj : collection) {
                if (!deniedByClass.containsKey(obj.getClass())) {
                    HashSet hashSet = new HashSet();
                    hashSet.add(obj);
                    deniedByClass.put(obj.getClass(), hashSet);
                    continue;
                }
                ((Set)deniedByClass.get(obj.getClass())).add(obj);
            }
            for (Class cls : deniedByClass.keySet()) {
                Set set = (Set)deniedByClass.get(cls);
                ResolverChain chain = this.getResolverChain(cls, action);
                for (PermissionResolver permissionResolver : chain.getResolvers()) {
                    permissionResolver.filterSetByAction(set, action);
                }
                for (PermissionResolver permissionResolver : set) {
                    collection.remove(permissionResolver);
                }
            }
        }
    }

    private ResolverChain createDefaultResolverChain() {
        ResolverChain chain = (ResolverChain)Contexts.getSessionContext().get(DEFAULT_RESOLVER_CHAIN);
        if (chain == null) {
            chain = new ResolverChain();
            for (String resolverName : Init.instance().getPermissionResolvers()) {
                chain.getResolvers().add((PermissionResolver)Component.getInstance(resolverName, true));
            }
            Contexts.getSessionContext().set(DEFAULT_RESOLVER_CHAIN, chain);
            if (Events.exists()) {
                Events.instance().raiseEvent(DEFAULT_RESOLVER_CHAIN_CREATED, chain);
            }
        }
        return chain;
    }

    public static PermissionMapper instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        PermissionMapper instance = (PermissionMapper)Component.getInstance(PermissionMapper.class, ScopeType.APPLICATION);
        if (instance == null) {
            throw new IllegalStateException("No PermissionMapper could be created");
        }
        return instance;
    }
}

