/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.ocm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.jboss.seam.jcr.ocm.ConvertToNode;
import org.jboss.seam.jcr.ocm.ConvertToObject;
import org.jboss.seam.jcr.ocm.JcrOCMExtension;
import org.jboss.seam.jcr.ocm.OCMMapping;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.reflection.Reflections;

public class NodeConverter {
    @Inject
    JcrOCMExtension ocmExtension;
    private Logger logger = Logger.getLogger(NodeConverter.class);

    public void handleConvertToObjectRequest(@Observes ConvertToObject event) throws RepositoryException {
        this.convertNodeToObject(event.getNode(), event.getClazz(), event.getObject());
    }

    public void handleConvertToNode(@Observes ConvertToNode event) throws RepositoryException {
        this.objectToNode(event.getObject(), event.getNode());
    }

    public <T> T nodeToObject(Node node, Class<T> nodeType) {
        try {
            T returnValue = nodeType.newInstance();
            this.convertNodeToObject(node, nodeType, returnValue);
            return returnValue;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate type " + nodeType, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate type " + nodeType, e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to read property on " + nodeType, e);
        }
    }

    public <T> void convertNodeToObject(Node node, Class<?> nodeType, Object returnValue) throws RepositoryException {
        OCMMapping mapping = this.ocmExtension.getOCMMappingStore().findMapping(nodeType);
        if (mapping == null) {
            throw new RuntimeException("No mapping found for class " + nodeType);
        }
        Set<String> jcrProperties = mapping.getPropertiesToFields().keySet();
        for (String jcrProperty : jcrProperties) {
            Field field = mapping.getPropertiesToFields().get(jcrProperty);
            Object value = null;
            if (field != null && jcrProperty.equalsIgnoreCase("uuid")) {
                value = node.getIdentifier();
            } else {
                try {
                    Property property = node.getProperty(jcrProperty);
                    if (field != null && property != null) {
                        Class<?> fieldType = field.getType();
                        if (fieldType.equals(Calendar.class)) {
                            value = property.getDate();
                        } else if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                            value = property.getBoolean();
                        } else if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                            value = property.getDouble();
                        } else if (fieldType.equals(BigDecimal.class)) {
                            value = property.getDecimal();
                        } else if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                            value = property.getLong();
                        } else if (fieldType.equals(String.class)) {
                            value = property.getString();
                        } else {
                            this.logger.warnf("invalid field type %s", (Object)field);
                        }
                    }
                }
                catch (RepositoryException e) {
                    this.logger.debug((Object)("No property found " + jcrProperty), (Throwable)e);
                }
            }
            if (value == null) continue;
            String setterMethodName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method method = Reflections.findDeclaredMethod(nodeType, (String)setterMethodName, (Class[])new Class[]{field.getType()});
            Reflections.invokeMethod((Method)method, (Object)returnValue, (Object[])new Object[]{value});
        }
    }

    public <T> void objectToNode(T object, Node node) throws RepositoryException {
        Class<?> nodeType = object.getClass();
        OCMMapping mapping = this.ocmExtension.getOCMMappingStore().findMapping(nodeType);
        Set<String> jcrProperties = mapping.getPropertiesToFields().keySet();
        this.logger.debug((Object)("The properties: " + jcrProperties));
        for (String jcrProperty : jcrProperties) {
            Field field = mapping.getPropertiesToFields().get(jcrProperty);
            this.logger.debugf("Searched for property [%s] and retrieved field [%s]", (Object)jcrProperty, (Object)field);
            String getterMethodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method method = Reflections.findDeclaredMethod(nodeType, (String)getterMethodName, (Class[])new Class[0]);
            this.logger.debug((Object)("Found method : " + method));
            Object value = Reflections.invokeMethod((Method)method, object, (Object[])new Object[0]);
            if (field != null && jcrProperty.equalsIgnoreCase("uuid") || field == null) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.equals(Calendar.class)) {
                node.setProperty(jcrProperty, (Calendar)value);
                continue;
            }
            if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                node.setProperty(jcrProperty, ((Boolean)value).booleanValue());
                continue;
            }
            if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                node.setProperty(jcrProperty, ((Double)value).doubleValue());
                continue;
            }
            if (fieldType.equals(BigDecimal.class)) {
                node.setProperty(jcrProperty, (BigDecimal)value);
                continue;
            }
            if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                node.setProperty(jcrProperty, ((Long)value).longValue());
                continue;
            }
            if (fieldType.equals(String.class)) {
                node.setProperty(jcrProperty, (String)value);
                continue;
            }
            this.logger.warnf("invalid field type %s", (Object)field);
        }
    }
}

