/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.ocm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.seam.jcr.annotations.ocm.JcrNode;
import org.jboss.seam.jcr.annotations.ocm.JcrProperty;
import org.jboss.seam.jcr.ocm.OCMMapping;
import org.jboss.solder.core.Veto;
import org.jboss.solder.logging.Logger;

@Veto
public class OCMMappingStore {
    private Logger logger = Logger.getLogger(OCMMappingStore.class);
    private Map<Class<?>, OCMMapping> mappingsByClass = new HashMap();
    private Map<String, OCMMapping> mappingsByNode = new HashMap<String, OCMMapping>();

    public Map<Class<?>, OCMMapping> getMappingsByClass() {
        return this.mappingsByClass;
    }

    public Map<String, OCMMapping> getMappingsByNode() {
        return this.mappingsByNode;
    }

    void addMapping(OCMMapping mapping) {
        this.mappingsByNode.put(mapping.getNodeType(), mapping);
        this.mappingsByClass.put(mapping.getNodeClass(), mapping);
    }

    public OCMMapping findMapping(String nodeType) {
        return this.mappingsByNode.get(nodeType);
    }

    public OCMMapping findMapping(Class<?> clazz) {
        return this.mappingsByClass.get(clazz);
    }

    void map(AnnotatedType<?> annotatedType, JcrNode jcrNode) {
        String fieldName;
        OCMMapping mapping = new OCMMapping();
        mapping.setNodeType(jcrNode.value());
        Class clazz = (Class)annotatedType.getBaseType();
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getMethods();
        mapping.setNodeClass(clazz);
        HashMap<String, JcrProperty> properties = new HashMap<String, JcrProperty>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(JcrProperty.class)) continue;
            fieldName = OCMMappingStore.getterToFieldName(method.getName());
            properties.put(fieldName, method.getAnnotation(JcrProperty.class));
        }
        for (AccessibleObject accessibleObject : fields) {
            this.logger.debugf("field name: %s", (Object)((Field)accessibleObject).getName());
            fieldName = ((Field)accessibleObject).getName();
            String prop = ((Field)accessibleObject).getName();
            JcrProperty property = ((Field)accessibleObject).getAnnotation(JcrProperty.class);
            if (property != null) {
                prop = property.value();
            } else if (properties.containsKey(prop)) {
                prop = ((JcrProperty)properties.get(prop)).value();
            }
            this.logger.debugf("fieldName: %s prop: %s\n", (Object)fieldName, (Object)prop);
            mapping.getPropertiesToFields().put(prop, (Field)accessibleObject);
            mapping.getFieldsToProperties().put(fieldName, prop);
        }
        this.addMapping(mapping);
    }

    private static String getterToFieldName(String methodName) {
        String fieldName = methodName.replace("get", "");
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
    }
}

