/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.seam.jms.impl.wrapper;

import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;

import org.jboss.seam.jms.annotations.JmsDestination;

/**
 * Wraps {@link AnnotatedParameter}s that declare transitive annotations to
 * {@link JmsDestination} with the actual {@link JmsDestination}.
 *
 * @author Jordan Ganoff
 */
public class JmsDestinationParameterWrapper<X> extends JmsDestinationAnnotatedWrapper implements AnnotatedParameter<X> {

    public JmsDestinationParameterWrapper(AnnotatedParameter<X> decorated) {
        super(decorated);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected AnnotatedParameter<X> decorated() {
        return AnnotatedParameter.class.cast(super.decorated());
    }

    public AnnotatedCallable<X> getDeclaringCallable() {
        return decorated().getDeclaringCallable();
    }

    public int getPosition() {
        return decorated().getPosition();
    }

}
