/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.example;

import java.net.MalformedURLException;
import java.util.UUID;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Model;
import javax.inject.Inject;
import javax.mail.Session;
import org.jboss.seam.mail.api.MailMessage;
import org.jboss.seam.mail.attachments.URLAttachment;
import org.jboss.seam.mail.core.EmailAttachment;
import org.jboss.seam.mail.core.EmailContact;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;
import org.jboss.seam.mail.core.enumerations.MessagePriority;
import org.jboss.seam.mail.example.Person;
import org.jboss.seam.mail.templating.TemplateProvider;
import org.jboss.seam.mail.templating.freemarker.FreeMarkerTemplate;
import org.jboss.seam.mail.templating.render.RenderTemplate;
import org.jboss.seam.mail.templating.velocity.CDIVelocityContext;
import org.jboss.seam.mail.templating.velocity.VelocityTemplate;
import org.jboss.seam.render.TemplateCompiler;
import org.jboss.seam.solder.resourceLoader.ResourceProvider;

@Model
public class SendMail {
    private String text = "Simple Message with text body";
    @Inject
    private Instance<MailMessage> mailMessage;
    @Inject
    private Instance<CDIVelocityContext> cDIVelocityContext;
    @Inject
    private ResourceProvider resourceProvider;
    @Inject
    private Instance<TemplateCompiler> templateCompiler;
    @Inject
    private Instance<Session> session;
    @Inject
    private Person person;

    public void sendText() {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to(this.person.getEmail(), this.person.getName()).subject("Text Message from Seam Mail - " + UUID.randomUUID().toString()).bodyText(this.text).send();
    }

    public void sendHTMLFreeMarker() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to((EmailContact)this.person).subject("HTML Message from Seam Mail - " + UUID.randomUUID().toString()).bodyHtml((TemplateProvider)new FreeMarkerTemplate(this.resourceProvider.loadResourceStream("template.html.freemarker"))).put("person", (Object)this.person).put("version", (Object)"Seam 3").importance(MessagePriority.HIGH).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }

    public void sendHTMLwithAlternativeFreeMarker() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to(this.person.getEmail(), this.person.getName()).subject("HTML+Text Message from Seam Mail - " + UUID.randomUUID().toString()).put("person", (Object)this.person).put("version", (Object)"Seam 3").bodyHtmlTextAlt((TemplateProvider)new FreeMarkerTemplate(this.resourceProvider.loadResourceStream("template.html.freemarker")), (TemplateProvider)new FreeMarkerTemplate(this.resourceProvider.loadResourceStream("template.text.freemarker"))).importance(MessagePriority.LOW).deliveryReceipt("seam@jboss.org").readReceipt("seam@jboss.org").addAttachment("template.html.freemarker", "text/html", ContentDisposition.ATTACHMENT, this.resourceProvider.loadResourceStream("template.html.freemarker")).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }

    public void sendHTMLVelocity() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to((EmailContact)this.person).subject("HTML Message from Seam Mail - " + UUID.randomUUID().toString()).bodyHtml((TemplateProvider)new VelocityTemplate(this.resourceProvider.loadResourceStream("template.html.velocity"), (CDIVelocityContext)this.cDIVelocityContext.get())).put("version", (Object)"Seam 3").importance(MessagePriority.HIGH).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }

    public void sendHTMLwithAlternativeVelocity() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to(this.person.getEmail(), this.person.getName()).subject("HTML+Text Message from Seam Mail - " + UUID.randomUUID().toString()).put("version", (Object)"Seam 3").bodyHtmlTextAlt((TemplateProvider)new VelocityTemplate(this.resourceProvider.loadResourceStream("template.html.velocity"), (CDIVelocityContext)this.cDIVelocityContext.get()), (TemplateProvider)new VelocityTemplate(this.resourceProvider.loadResourceStream("template.text.velocity"), (CDIVelocityContext)this.cDIVelocityContext.get())).importance(MessagePriority.LOW).deliveryReceipt("seam@jboss.org").readReceipt("seam@jboss.org").addAttachment("template.html.velocity", "text/html", ContentDisposition.ATTACHMENT, this.resourceProvider.loadResourceStream("template.html.velocity")).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }

    public void sendHTMLRender() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to((EmailContact)this.person).subject("HTML Message from Seam Mail - " + UUID.randomUUID().toString()).bodyHtml((TemplateProvider)new RenderTemplate((TemplateCompiler)this.templateCompiler.get(), "template.html.render")).put("version", (Object)"Seam 3").importance(MessagePriority.HIGH).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }

    public void sendHTMLwithAlternativeRender() throws MalformedURLException {
        ((MailMessage)this.mailMessage.get()).from("seam@test.test", "Seam Framework").to(this.person.getEmail(), this.person.getName()).subject("HTML+Text Message from Seam Mail - " + UUID.randomUUID().toString()).put("version", (Object)"Seam 3").bodyHtmlTextAlt((TemplateProvider)new RenderTemplate((TemplateCompiler)this.templateCompiler.get(), "template.html.render"), (TemplateProvider)new RenderTemplate((TemplateCompiler)this.templateCompiler.get(), "template.text.render")).importance(MessagePriority.LOW).deliveryReceipt("seam@jboss.org").readReceipt("seam@jboss.org").addAttachment("template.html.render", "text/html", ContentDisposition.ATTACHMENT, this.resourceProvider.loadResourceStream("template.html.render")).addAttachment((EmailAttachment)new URLAttachment("http://www.seamframework.org/themes/sfwkorg/img/seam_icon_large.png", "seamLogo.png", ContentDisposition.INLINE)).send((Session)this.session.get());
    }
}

