/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.attachments;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.activation.FileDataSource;
import org.jboss.seam.mail.attachments.BaseAttachment;
import org.jboss.seam.mail.core.AttachmentException;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;

public class FileAttachment
extends BaseAttachment {
    public FileAttachment(ContentDisposition contentDisposition, File file) {
        FileDataSource fds = new FileDataSource(file);
        try {
            super.setFileName(fds.getName());
            super.setMimeType(fds.getContentType());
            super.setContentDisposition(contentDisposition);
            super.setBytes(Files.toByteArray((File)file));
        }
        catch (IOException e) {
            throw new AttachmentException("Wasn't able to create email attachment from File: " + file.getName(), (Throwable)e);
        }
    }

    public FileAttachment(ContentDisposition contentDisposition, File file, String contentClass) {
        this(contentDisposition, file);
        super.addHeader(new Header("Content-Class", contentClass));
    }
}

