/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.templating.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.mail.templating.TemplateProvider;
import org.jboss.seam.mail.templating.TemplatingException;

public class FreeMarkerTemplate
implements TemplateProvider {
    private Configuration configuration;
    private Map<String, Object> rootMap = new HashMap<String, Object>();
    private InputStream inputStream;

    public FreeMarkerTemplate(InputStream inputStream) {
        this.inputStream = inputStream;
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public FreeMarkerTemplate(String string) {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public FreeMarkerTemplate(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public String merge(Map<String, Object> context) {
        this.rootMap.putAll(context);
        StringWriter writer = new StringWriter();
        try {
            Template template = new Template("mailGenerated", (Reader)new InputStreamReader(this.inputStream), this.configuration);
            template.process(this.rootMap, (Writer)writer);
        }
        catch (IOException e) {
            throw new TemplatingException("Error creating template", e);
        }
        catch (TemplateException e) {
            throw new TemplatingException("Error rendering output", e);
        }
        return writer.toString();
    }
}

