/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.templating.velocity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.jboss.seam.mail.templating.TemplateProvider;
import org.jboss.seam.mail.templating.TemplatingException;
import org.jboss.seam.mail.templating.velocity.CDIVelocityContext;

public class VelocityTemplate
implements TemplateProvider {
    private VelocityEngine velocityEngine = new VelocityEngine();
    private VelocityContext velocityContext;
    private CDIVelocityContext cdiContext;
    private InputStream inputStream;

    public VelocityTemplate(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public VelocityTemplate(InputStream inputStream, CDIVelocityContext cdiContext) {
        this(inputStream);
        this.cdiContext = cdiContext;
    }

    public VelocityTemplate(String string) {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public VelocityTemplate(String string, CDIVelocityContext cdiContext) {
        this(new ByteArrayInputStream(string.getBytes()), cdiContext);
    }

    public VelocityTemplate(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public VelocityTemplate(File file, CDIVelocityContext cdiContext) throws FileNotFoundException {
        this(new FileInputStream(file), cdiContext);
    }

    public String merge(Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        this.velocityContext = this.cdiContext != null ? new VelocityContext(context, (Context)this.cdiContext) : new VelocityContext(context);
        try {
            this.velocityEngine.evaluate((Context)this.velocityContext, (Writer)writer, "mailGenerated", (Reader)new InputStreamReader(this.inputStream));
        }
        catch (ResourceNotFoundException e) {
            throw new TemplatingException("Unable to find template", e);
        }
        catch (ParseErrorException e) {
            throw new TemplatingException("Unable to find template", e);
        }
        catch (MethodInvocationException e) {
            throw new TemplatingException("Error processing method referenced in context", e);
        }
        catch (IOException e) {
            throw new TemplatingException("Error rendering output", e);
        }
        return writer.toString();
    }
}

