/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate.test;

import java.util.List;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.hibernate.Session;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.ManagedHibernateSessionProvider;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedHibernateSessionTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    Session session;

    public static Class<?>[] getTestClasses() {
        return new Class[]{ManagedHibernateSessionTestBase.class, Hotel.class, ManagedHibernateSessionProvider.class, HelloService.class};
    }

    @Test
    public void testManagedHibernateSession() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        Hotel h = new Hotel("test", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.commit();
        this.transaction.begin();
        h = new Hotel("test2", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.rollback();
        this.transaction.begin();
        List hotels = this.session.createQuery("select h from Hotel h").list();
        Assert.assertEquals((int)1, (int)hotels.size());
        this.transaction.rollback();
    }
}

