/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.test;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.ManagedPersistenceContextProvider;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPersistenceContextTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    EntityManager em;

    public static Class<?>[] getTestClasses() {
        return new Class[]{ManagedPersistenceContextTestBase.class, Hotel.class, ManagedPersistenceContextProvider.class, HelloService.class};
    }

    @Test
    public void testManagedPersistenceContext() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        Hotel h = new Hotel("test", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.commit();
        this.transaction.begin();
        h = new Hotel("test2", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.rollback();
        this.transaction.begin();
        List hotels = this.em.createQuery("select h from Hotel h").getResultList();
        Assert.assertEquals((int)1, (int)hotels.size());
        this.transaction.rollback();
    }
}

