/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transactions.test;

import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.transactions.test.TransactionScopedObject;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScopedTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @PersistenceUnit
    EntityManagerFactory emf;
    @Inject
    TransactionScopedObject transactionScopedObject;

    public static Class<?>[] getTestClasses() {
        return new Class[]{TransactionScopedTestBase.class, Hotel.class, HelloService.class, TransactionScopedObject.class};
    }

    @Test
    public void transactionScopeTest() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        this.transactionScopedObject.setValue(10);
        Assert.assertTrue((this.transactionScopedObject.getValue() == 10 ? 1 : 0) != 0);
        this.transaction.commit();
        this.transaction.begin();
        Assert.assertTrue((this.transactionScopedObject.getValue() == 0 ? 1 : 0) != 0);
        this.transactionScopedObject.setValue(20);
        Assert.assertTrue((this.transactionScopedObject.getValue() == 20 ? 1 : 0) != 0);
        this.transaction.rollback();
        this.transaction.begin();
        Assert.assertTrue((this.transactionScopedObject.getValue() == 0 ? 1 : 0) != 0);
        this.transaction.rollback();
    }
}

