/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.test;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.HotelNameProducer;
import org.jboss.seam.persistence.test.util.ManagedPersistenceContextProvider;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ManagedPersistenceContextELTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    EntityManager em;

    public static Class<?>[] getTestClasses() {
        return new Class[]{ManagedPersistenceContextELTestBase.class, Hotel.class, ManagedPersistenceContextProvider.class, HotelNameProducer.class, HelloService.class};
    }

    @Test
    public void testELInInquery() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        Hotel h = new Hotel("Hilton", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.commit();
        this.transaction.begin();
        h = new Hotel("Other Hotel", "Real St ", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.commit();
        this.transaction.begin();
        Hotel hilton = (Hotel)this.em.createQuery("select h from Hotel h where h.name=#{hotelName}").getSingleResult();
        Assert.assertTrue((boolean)hilton.getName().equals("Hilton"));
        Assert.assertTrue((boolean)hilton.getAddress().equals("Fake St"));
        this.transaction.commit();
    }
}

