/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.Synchronization;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.SeamPersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceProvider
implements SeamPersistenceProvider {
    protected Set<Feature> featureSet = new HashSet<Feature>();

    public boolean supportsFeature(Feature feature) {
        return this.featureSet.contains((Object)feature);
    }

    @Override
    public boolean isCorrectProvider(EntityManager em) {
        return true;
    }

    @Override
    public void setFlushMode(EntityManager entityManager, FlushModeType type) {
        switch (type) {
            case AUTO: {
                entityManager.setFlushMode(javax.persistence.FlushModeType.AUTO);
                break;
            }
            case COMMIT: {
                entityManager.setFlushMode(javax.persistence.FlushModeType.COMMIT);
                break;
            }
            case MANUAL: {
                this.setFlushModeManual(entityManager);
                break;
            }
            default: {
                throw new RuntimeException("Unkown flush mode: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void setFlushModeManual(EntityManager entityManager) {
        throw new UnsupportedOperationException("Use of FlushMode.MANUAL requires Hibernate as the persistence provider. Please use Hibernate, a custom persistenceProvider, or remove the MANUAL flush mode setting.");
    }

    @Override
    public FlushModeType getRenderFlushMode() {
        return FlushModeType.COMMIT;
    }

    @Override
    public boolean isDirty(EntityManager entityManager) {
        return true;
    }

    @Override
    public Object getId(Object bean, EntityManager entityManager) {
        return null;
    }

    @Override
    public String getName(Object bean, EntityManager entityManager) throws IllegalArgumentException {
        return null;
    }

    @Override
    public Object getVersion(Object bean, EntityManager entityManager) {
        return null;
    }

    @Override
    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        boolean equal = oldVersion instanceof Date ? ((Date)oldVersion).getTime() == ((Date)version).getTime() : oldVersion.equals(version);
        if (!equal) {
            throw new OptimisticLockException("Current database version number does not match passivated version number");
        }
    }

    @Override
    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        return false;
    }

    @Override
    public Object proxyDelegate(Object delegate) {
        return delegate;
    }

    @Override
    public EntityManager proxyEntityManager(EntityManager entityManager) {
        return entityManager;
    }

    @Override
    public Set<Class<?>> getAdditionalEntityManagerInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public Class<?> getBeanClass(Object bean) {
        return null;
    }

    public Method getPostLoadMethod(Object bean, EntityManager entityManager) {
        return null;
    }

    public Method getPrePersistMethod(Object bean, EntityManager entityManager) {
        return null;
    }

    public Method getPreUpdateMethod(Object bean, EntityManager entityManager) {
        return null;
    }

    public Method getPreRemoveMethod(Object bean, EntityManager entityManager) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        WILDCARD_AS_COUNT_QUERY_SUBJECT;

    }
}

