/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import org.jboss.seam.persistence.DefaultPersistenceProvider;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.ManagedPersistenceContextBeanLifecycle;
import org.jboss.seam.persistence.SeamManaged;
import org.jboss.seam.persistence.SeamPersistenceProvider;
import org.jboss.seam.persistence.util.EnvironmentUtils;
import org.jboss.seam.solder.bean.BeanBuilder;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.bean.ContextualLifecycle;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.ApplicationScopedLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.seam.solder.reflection.annotated.Annotateds;
import org.jboss.seam.solder.util.service.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPersistenceContextExtension
implements Extension {
    Set<Bean<?>> beans = new HashSet();
    List<SeamPersistenceProvider> persistenceProviders = new ArrayList<SeamPersistenceProvider>();
    private static final Logger log = LoggerFactory.getLogger(ManagedPersistenceContextExtension.class);

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        try {
            Class hibernateProviderClass = Reflections.classForName((String)"org.jboss.seam.persistence.HibernatePersistenceProvider", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
            SeamPersistenceProvider provider = (SeamPersistenceProvider)hibernateProviderClass.newInstance();
            this.persistenceProviders.add(provider);
        }
        catch (NoClassDefFoundError e) {
            log.debug("Hibernate not found on class path, HibernatePersistenceProvider not loaded.");
        }
        catch (ClassNotFoundException e) {
            log.debug("Hibernate not found on class path, HibernatePersistenceProvider not loaded.");
        }
        catch (InstantiationException e) {
            log.debug("InstantiationException creating HibernatePersistenceProvider: HibernatePersistenceProvider not loaded.");
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException creating HibernatePersistenceProvider: HibernatePersistenceProvider not loaded.");
        }
        ServiceLoader providers = ServiceLoader.load(SeamPersistenceProvider.class);
        for (SeamPersistenceProvider i : providers) {
            this.persistenceProviders.add(i);
        }
        this.persistenceProviders.add(new DefaultPersistenceProvider());
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event, BeanManager manager) {
        AnnotatedTypeBuilder modifiedType = null;
        for (AnnotatedField field : event.getAnnotatedType().getFields()) {
            boolean bootstrapped = false;
            if (field.isAnnotationPresent(PersistenceUnit.class) && field.isAnnotationPresent(Produces.class) && !EnvironmentUtils.isEEEnvironment()) {
                bootstrapped = true;
                String unitName = ((PersistenceUnit)field.getAnnotation(PersistenceUnit.class)).unitName();
                Set qualifiers = Beans.getQualifiers((BeanManager)manager, (Iterable)field.getAnnotations());
                if (qualifiers.isEmpty()) {
                    qualifiers.add(DefaultLiteral.INSTANCE);
                }
                qualifiers.add(AnyLiteral.INSTANCE);
                this.beans.add(this.createEMFBean(unitName, qualifiers, event.getAnnotatedType(), manager));
            }
            if (!field.isAnnotationPresent(SeamManaged.class) || !field.isAnnotationPresent(PersistenceUnit.class) && !field.isAnnotationPresent(Resource.class) || !field.isAnnotationPresent(Produces.class) || !EntityManagerFactory.class.isAssignableFrom(field.getJavaMember().getType())) continue;
            if (modifiedType == null) {
                modifiedType = new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType());
            }
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            Class scope = Dependent.class;
            for (Annotation annotation : field.getAnnotations()) {
                if (manager.isQualifier(annotation.annotationType())) {
                    qualifiers.add(annotation);
                    continue;
                }
                if (!manager.isScope(annotation.annotationType())) continue;
                scope = annotation.annotationType();
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)new DefaultLiteral());
            }
            qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            if (scope != Dependent.class) {
                modifiedType.removeFromField(field.getJavaMember(), scope);
            }
            if (bootstrapped) {
                modifiedType.removeFromField(field.getJavaMember(), Produces.class);
            }
            this.registerManagedPersistenceContext((Set<Annotation>)qualifiers, scope, field.isAnnotationPresent(Alternative.class), manager, event.getAnnotatedType().getJavaClass().getClassLoader(), (AnnotatedMember<?>)field, event.getAnnotatedType().getJavaClass());
            log.info("Configuring Seam Managed Persistence Context from producer field " + event.getAnnotatedType().getJavaClass().getName() + "." + field.getJavaMember().getName() + " with qualifiers " + qualifiers);
        }
        for (AnnotatedMethod method : event.getAnnotatedType().getMethods()) {
            if (!method.isAnnotationPresent(SeamManaged.class) || !method.isAnnotationPresent(Produces.class) || !EntityManagerFactory.class.isAssignableFrom(method.getJavaMember().getReturnType())) continue;
            if (modifiedType == null) {
                modifiedType = new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType());
            }
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            Class scope = Dependent.class;
            for (Annotation annotation : method.getAnnotations()) {
                if (manager.isQualifier(annotation.annotationType())) {
                    qualifiers.add(annotation);
                    continue;
                }
                if (!manager.isScope(annotation.annotationType())) continue;
                scope = annotation.annotationType();
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)new DefaultLiteral());
            }
            qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            modifiedType.removeFromMethod(method.getJavaMember(), scope);
            modifiedType.addToMethod(method.getJavaMember(), (Annotation)ApplicationScopedLiteral.INSTANCE);
            this.registerManagedPersistenceContext((Set<Annotation>)qualifiers, scope, method.isAnnotationPresent(Alternative.class), manager, event.getAnnotatedType().getJavaClass().getClassLoader(), (AnnotatedMember<?>)method, event.getAnnotatedType().getJavaClass());
            log.info("Configuring Seam Managed Persistence Context from producer method " + event.getAnnotatedType().getJavaClass().getName() + "." + method.getJavaMember().getName() + " with qualifiers " + qualifiers);
        }
        if (modifiedType != null) {
            event.setAnnotatedType(modifiedType.create());
        }
    }

    private Bean<?> createEMFBean(final String unitName, Set<Annotation> qualifiers, AnnotatedType<?> type, BeanManager beanManager) {
        BeanBuilder builder = new BeanBuilder(beanManager);
        HashSet<Class> types = new HashSet<Class>();
        types.add(EntityManagerFactory.class);
        types.add(Object.class);
        builder.beanClass(type.getJavaClass()).qualifiers(qualifiers).types(types);
        builder.beanLifecycle((ContextualLifecycle)new ContextualLifecycle<EntityManagerFactory>(){

            public void destroy(Bean<EntityManagerFactory> bean, EntityManagerFactory instance, CreationalContext<EntityManagerFactory> creationalContext) {
                instance.close();
                creationalContext.release();
            }

            public EntityManagerFactory create(Bean<EntityManagerFactory> bean, CreationalContext<EntityManagerFactory> creationalContext) {
                return Persistence.createEntityManagerFactory((String)unitName);
            }
        });
        return builder.create();
    }

    private void registerManagedPersistenceContext(Set<Annotation> qualifiers, Class<? extends Annotation> scope, boolean alternative, BeanManager manager, ClassLoader loader, AnnotatedMember<?> member, Class<?> declaringClass) {
        HashSet additionalInterfaces = new HashSet();
        for (SeamPersistenceProvider i : this.persistenceProviders) {
            additionalInterfaces.addAll(i.getAdditionalEntityManagerInterfaces());
        }
        ManagedPersistenceContextBeanLifecycle lifecycle = new ManagedPersistenceContextBeanLifecycle(qualifiers, loader, manager, additionalInterfaces, this.persistenceProviders);
        AnnotatedTypeBuilder typeBuilder = new AnnotatedTypeBuilder().setJavaClass(EntityManager.class);
        BeanBuilder builder = new BeanBuilder(manager).readFromType(typeBuilder.create());
        builder.qualifiers(qualifiers);
        builder.scope(scope);
        builder.beanClass(member.getDeclaringType().getJavaClass());
        builder.getTypes().add(ManagedPersistenceContext.class);
        builder.getTypes().addAll(additionalInterfaces);
        builder.getTypes().add(Object.class);
        builder.beanLifecycle((ContextualLifecycle)lifecycle);
        builder.alternative(alternative);
        StringBuilder id = new StringBuilder("SMPC-" + ManagedPersistenceContextExtension.class.getName() + "-");
        if (member instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)member;
            id.append(Annotateds.createFieldId((AnnotatedField)field));
        } else {
            AnnotatedCallable method = (AnnotatedCallable)member;
            id.append(Annotateds.createCallableId((AnnotatedCallable)method));
        }
        builder.id(id.toString());
        builder.passivationCapable(true);
        builder.toString("Seam Managed Persistence Context with qualifiers [" + qualifiers + "] with configured by [" + member + "] on class [" + declaringClass + "]");
        this.beans.add(builder.create());
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        for (Bean<?> i : this.beans) {
            event.addBean(i);
        }
    }
}

