/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.seam.persistence.hibernate.HibernateExtension;
import org.jboss.seam.persistence.hibernate.HibernateManagedSessionExtensionImpl;
import org.jboss.seam.solder.reflection.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateManagedSessionExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(HibernateManagedSessionExtension.class);
    private final boolean enabled;
    private HibernateExtension delegate;

    public HibernateManagedSessionExtension() {
        boolean en = true;
        try {
            Reflections.classForName((String)"org.hibernate.Session", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
            this.delegate = new HibernateManagedSessionExtensionImpl();
        }
        catch (ClassNotFoundException e) {
            log.debug("Hibernate not found on the classpath, Managed Hibernate Sessions are disabled");
            en = false;
        }
        this.enabled = en;
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event, BeanManager manager) {
        if (this.enabled) {
            this.delegate.processAnnotatedType(event, manager);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        if (this.enabled) {
            this.delegate.afterBeanDiscovery(event);
        }
    }
}

