/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.persistence.transaction.CMTTransaction;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.NoTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.transaction.Synchronizations;
import org.jboss.seam.persistence.transaction.UTTransaction;
import org.jboss.seam.persistence.util.EJBContextUtils;
import org.jboss.seam.persistence.util.NamingUtils;
import org.jboss.seam.solder.bean.defaultbean.DefaultBean;

@DefaultBean(value=SeamTransaction.class)
@DefaultTransaction
public class DefaultSeamTransaction
implements SeamTransaction {
    @Inject
    private Synchronizations synchronizations;

    public void enlist(EntityManager entityManager) throws SystemException {
        this.getSeamTransaction().enlist(entityManager);
    }

    public boolean isActive() throws SystemException {
        return this.getSeamTransaction().isActive();
    }

    public boolean isActiveOrMarkedRollback() throws SystemException {
        return this.getSeamTransaction().isActiveOrMarkedRollback();
    }

    public boolean isCommitted() throws SystemException {
        return this.getSeamTransaction().isCommitted();
    }

    public boolean isConversationContextRequired() {
        return this.getSeamTransaction().isConversationContextRequired();
    }

    public boolean isMarkedRollback() throws SystemException {
        return this.getSeamTransaction().isMarkedRollback();
    }

    public boolean isNoTransaction() throws SystemException {
        return this.getSeamTransaction().isNoTransaction();
    }

    public boolean isRolledBack() throws SystemException {
        return this.getSeamTransaction().isRolledBack();
    }

    public boolean isRolledBackOrMarkedRollback() throws SystemException {
        return this.getSeamTransaction().isRolledBackOrMarkedRollback();
    }

    public void registerSynchronization(Synchronization sync) {
        this.getSeamTransaction().registerSynchronization(sync);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getSeamTransaction().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getSeamTransaction().commit();
    }

    public int getStatus() throws SystemException {
        return this.getSeamTransaction().getStatus();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getSeamTransaction().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getSeamTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getSeamTransaction().setTransactionTimeout(seconds);
    }

    protected SeamTransaction getSeamTransaction() {
        try {
            return this.createUTTransaction();
        }
        catch (NameNotFoundException nnfe) {
            try {
                return this.createCMTTransaction();
            }
            catch (NameNotFoundException nnfe2) {
                return this.createNoTransaction();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected SeamTransaction createNoTransaction() {
        return new NoTransaction();
    }

    protected SeamTransaction createCMTTransaction() throws NamingException {
        return new CMTTransaction(EJBContextUtils.getEJBContext(), this.synchronizations);
    }

    protected SeamTransaction createUTTransaction() throws NamingException {
        return new UTTransaction(this.getUserTransaction(), this.synchronizations);
    }

    protected UserTransaction getUserTransaction() throws NamingException {
        InitialContext context = NamingUtils.getInitialContext();
        try {
            return (UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NameNotFoundException nnfe) {
            try {
                UserTransaction ut = (UserTransaction)context.lookup("UserTransaction");
                ut.getStatus();
                return ut;
            }
            catch (Exception e) {
                throw nnfe;
            }
        }
    }
}

