/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.ejb.EJBException;
import javax.ejb.Remove;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.transaction.Synchronization;
import org.jboss.seam.persistence.transaction.LocalEjbSynchronizations;
import org.jboss.seam.persistence.transaction.SynchronizationRegistry;
import org.jboss.seam.persistence.transaction.Synchronizations;
import org.jboss.seam.solder.bean.defaultbean.DefaultBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateful
@RequestScoped
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
@DefaultBean(value=Synchronizations.class)
public class EjbSynchronizations
implements LocalEjbSynchronizations,
SessionSynchronization {
    private static final Logger log = LoggerFactory.getLogger(EjbSynchronizations.class);
    @Inject
    private BeanManager beanManager;
    protected LinkedList<SynchronizationRegistry> synchronizations = new LinkedList();
    protected LinkedList<SynchronizationRegistry> committing = new LinkedList();

    public void afterBegin() {
        log.debug("afterBegin");
        this.synchronizations.addLast(new SynchronizationRegistry(this.beanManager));
    }

    public void beforeCompletion() throws EJBException, RemoteException {
        log.debug("beforeCompletion");
        SynchronizationRegistry sync = this.synchronizations.removeLast();
        sync.beforeTransactionCompletion();
        this.committing.addLast(sync);
    }

    public void afterCompletion(boolean success) throws EJBException, RemoteException {
        log.debug("afterCompletion");
        if (this.committing.isEmpty()) {
            if (success) {
                throw new IllegalStateException("beforeCompletion was never called");
            }
            this.synchronizations.removeLast().afterTransactionCompletion(false);
        } else {
            this.committing.removeFirst().afterTransactionCompletion(success);
        }
    }

    public boolean isAwareOfContainerTransactions() {
        return true;
    }

    public void afterTransactionBegin() {
    }

    public void afterTransactionCompletion(boolean success) {
    }

    public void beforeTransactionCommit() {
    }

    public void registerSynchronization(Synchronization sync) {
        this.synchronizations.getLast().registerSynchronization(sync);
    }

    @Remove
    public void destroy() {
    }
}

