/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import java.util.Stack;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.transaction.Synchronization;
import org.jboss.seam.persistence.transaction.SynchronizationRegistry;
import org.jboss.seam.persistence.transaction.Synchronizations;
import org.jboss.seam.solder.core.Veto;

@RequestScoped
@Veto
public class SeSynchronizations
implements Synchronizations {
    protected Stack<SynchronizationRegistry> synchronizations = new Stack();
    @Inject
    private BeanManager beanManager;

    public void afterTransactionBegin() {
        this.synchronizations.push(new SynchronizationRegistry(this.beanManager));
    }

    public void afterTransactionCompletion(boolean success) {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.pop().afterTransactionCompletion(success);
        }
    }

    public void beforeTransactionCommit() {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.peek().beforeTransactionCompletion();
        }
    }

    public void registerSynchronization(Synchronization sync) {
        if (this.synchronizations.isEmpty()) {
            throw new IllegalStateException("Transaction begin not detected, try installing transaction:ejb-transaction in components.xml");
        }
        this.synchronizations.peek().registerSynchronization(sync);
    }

    public boolean isAwareOfContainerTransactions() {
        return false;
    }
}

