/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.seam.persistence.transaction.TransactionInterceptorBindingLiteral;
import org.jboss.seam.persistence.transaction.Transactional;
import org.jboss.seam.persistence.util.EjbApi;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(TransactionExtension.class);
    private final Set<Throwable> exceptions = new HashSet<Throwable>();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        AnnotatedTypeBuilder builder = null;
        AnnotatedType type = event.getAnnotatedType();
        boolean addedToClass = false;
        if (type.isAnnotationPresent(Transactional.class)) {
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            addedToClass = true;
        } else if (type.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE) && !EjbApi.isEjb(event.getAnnotatedType())) {
            this.checkTransactionAttributeIsValue(type, (Annotated)type);
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            addedToClass = true;
        }
        if (!addedToClass) {
            for (AnnotatedMethod m : type.getMethods()) {
                if (m.isAnnotationPresent(Transactional.class)) {
                    if (builder == null) {
                        builder = new AnnotatedTypeBuilder().readFromType(type);
                    }
                    builder.addToMethod(m, (Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
                    continue;
                }
                if (!m.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE) || EjbApi.isEjb(event.getAnnotatedType())) continue;
                this.checkTransactionAttributeIsValue(type, (Annotated)m);
                if (builder == null) {
                    builder = new AnnotatedTypeBuilder().readFromType(type);
                }
                builder.addToMethod(m, (Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            }
        }
        if (builder != null) {
            event.setAnnotatedType(builder.create());
        }
    }

    private void afterBeanDiscover(@Observes AfterBeanDiscovery event) {
        for (Throwable throwable : this.exceptions) {
            event.addDefinitionError(throwable);
        }
    }

    private void checkTransactionAttributeIsValue(AnnotatedType type, Annotated element) {
        Annotation attribute = element.getAnnotation(EjbApi.TRANSACTION_ATTRIBUTE);
        if (attribute == EjbApi.REQUIRES_NEW) {
            this.exceptions.add(new RuntimeException("TransactionAttributeType.REQUIRED_NEW is not supported on Managed Beans that are not EJB's. Annotation was found on type " + type));
        }
        if (attribute == EjbApi.NOT_SUPPORTED) {
            this.exceptions.add(new RuntimeException("TransactionAttributeType.NOT_SUPPORTED is not supported on Managed Beans that are not EJB's. Annotation was found on type " + type));
        }
    }
}

