/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.transaction.TransactionPropagation;
import org.jboss.seam.persistence.transaction.Transactional;
import org.jboss.seam.persistence.transaction.TransactionalInterceptorBinding;
import org.jboss.seam.persistence.transaction.Work;
import org.jboss.seam.persistence.util.EjbApi;

@TransactionalInterceptorBinding
@Interceptor
public class TransactionInterceptor
implements Serializable {
    private static final long serialVersionUID = -4364203056333738988L;
    private transient Map<AnnotatedElement, TransactionMetadata> transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
    @Inject
    @DefaultTransaction
    Instance<SeamTransaction> transaction;

    private TransactionMetadata lookupTransactionMetadata(AnnotatedElement element) {
        TransactionMetadata metadata;
        if (this.transactionMetadata == null) {
            this.transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
        }
        if ((metadata = this.transactionMetadata.get(element)) == null) {
            metadata = this.loadMetadata(element);
        }
        return metadata;
    }

    private synchronized TransactionMetadata loadMetadata(AnnotatedElement element) {
        if (!this.transactionMetadata.containsKey(element)) {
            TransactionMetadata metadata = new TransactionMetadata(element);
            this.transactionMetadata.put(element, metadata);
            return metadata;
        }
        return this.transactionMetadata.get(element);
    }

    @AroundInvoke
    public Object aroundInvoke(final InvocationContext invocation) throws Exception {
        return new Work(){

            protected Object work() throws Exception {
                return invocation.proceed();
            }

            @Override
            protected boolean isNewTransactionRequired(boolean transactionActive) {
                return this.isNewTransactionRequired(invocation.getMethod(), invocation.getTarget().getClass(), transactionActive);
            }

            private boolean isNewTransactionRequired(Method method, Class<?> beanClass, boolean transactionActive) {
                TransactionMetadata metadata = TransactionInterceptor.this.lookupTransactionMetadata(method);
                if (metadata.isAnnotationPresent()) {
                    return metadata.isNewTransactionRequired(transactionActive);
                }
                metadata = TransactionInterceptor.this.lookupTransactionMetadata(beanClass);
                return metadata.isNewTransactionRequired(transactionActive);
            }
        }.workInTransaction((SeamTransaction)this.transaction.get());
    }

    private class TransactionMetadata {
        private boolean annotationPresent;
        TransactionPropagation propType;

        public TransactionMetadata(AnnotatedElement element) {
            block11: {
                this.annotationPresent = element.isAnnotationPresent(Transactional.class);
                if (this.annotationPresent) {
                    this.propType = element.getAnnotation(Transactional.class).value();
                } else if (element.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE)) {
                    this.annotationPresent = true;
                    Annotation annotation = element.getAnnotation(EjbApi.TRANSACTION_ATTRIBUTE);
                    try {
                        Object value = annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (value == EjbApi.REQUIRED) {
                            this.propType = TransactionPropagation.REQUIRED;
                            break block11;
                        }
                        if (value == EjbApi.MANDATORY) {
                            this.propType = TransactionPropagation.MANDATORY;
                            break block11;
                        }
                        if (value == EjbApi.NEVER) {
                            this.propType = TransactionPropagation.NEVER;
                            break block11;
                        }
                        if (value == EjbApi.SUPPORTS) {
                            this.propType = TransactionPropagation.SUPPORTS;
                            break block11;
                        }
                        if (value == EjbApi.NOT_SUPPORTED) {
                            throw new RuntimeException("TransactionAttributeType.NOT_SUPPORTED is not allowed on managed beans that are not EJB's. Element: " + element);
                        }
                        if (value == EjbApi.REQUIRES_NEW) {
                            throw new RuntimeException("TransactionAttributeType.REQUIRES_NEW is not allowed on managed beans that are not EJB's Element: " + element);
                        }
                        throw new RuntimeException("Unkown TransactionAttributeType: " + value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        public boolean isAnnotationPresent() {
            return this.annotationPresent;
        }

        public boolean isNewTransactionRequired(boolean transactionActive) {
            return this.propType != null && this.propType.isNewTransactionRequired(transactionActive);
        }
    }
}

