/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction;

import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Work<T> {
    private static final Logger log = LoggerFactory.getLogger(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction(SeamTransaction transaction) throws Exception {
        boolean transactionActive = transaction.isActiveOrMarkedRollback() || transaction.isRolledBack();
        boolean newTransactionRequired = this.isNewTransactionRequired(transactionActive);
        try {
            if (newTransactionRequired) {
                log.debug("beginning transaction");
                transaction.begin();
            }
            T result = this.work();
            if (newTransactionRequired) {
                if (transaction.isMarkedRollback()) {
                    log.debug("rolling back transaction");
                    transaction.rollback();
                } else {
                    log.debug("committing transaction");
                    transaction.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            if (newTransactionRequired && transaction.getStatus() != 6) {
                if (ExceptionUtil.exceptionCausesRollback(e)) {
                    log.debug("rolling back transaction");
                    transaction.rollback();
                } else {
                    log.debug("committing transaction after ApplicationException(rollback=false):" + e.getMessage());
                    transaction.commit();
                }
            } else if (transaction.getStatus() != 6 && ExceptionUtil.exceptionCausesRollback(e)) {
                transaction.setRollbackOnly();
            }
            throw e;
        }
    }
}

