/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transaction.scope;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.transaction.TransactionScoped;
import org.jboss.seam.persistence.transaction.literal.DefaultTransactionLiteral;
import org.jboss.seam.persistence.transaction.scope.ContextualIdentifierStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScopeContext
implements Context,
Synchronization {
    private SeamTransaction userTransaction;
    private final BeanManager beanManager;
    private final ContextualIdentifierStore identifierStore = new ContextualIdentifierStore();
    private final ThreadLocal<TransactionScopeData> contextData = new ThreadLocal<TransactionScopeData>(){

        @Override
        protected TransactionScopeData initialValue() {
            return new TransactionScopeData();
        }
    };

    public TransactionScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitialization() {
        if (this.userTransaction == null) {
            TransactionScopeContext transactionScopeContext = this;
            synchronized (transactionScopeContext) {
                if (this.userTransaction == null) {
                    Bean bean = this.beanManager.resolve(this.beanManager.getBeans(SeamTransaction.class, new Annotation[]{DefaultTransactionLiteral.INSTANCE}));
                    if (bean == null) {
                        throw new RuntimeException("Could not find SeamTransaction bean with qualifier " + DefaultTransaction.class.getName());
                    }
                    CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
                    this.userTransaction = (SeamTransaction)this.beanManager.getReference(bean, SeamTransaction.class, ctx);
                }
            }
        }
    }

    private void registerSyncronization() {
        TransactionScopeData data = this.contextData.get();
        if (!data.isSyncronisationRegistered()) {
            this.userTransaction.registerSynchronization(this);
            data.setSyncronisationRegistered(true);
        }
    }

    public <T> T get(Contextual<T> contextual) {
        this.lazyInitialization();
        this.registerSyncronization();
        String id = this.identifierStore.getId(contextual);
        Map<String, Object> map = this.contextData.get().getInstanceStore();
        return (T)map.get(id);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        this.lazyInitialization();
        this.registerSyncronization();
        String id = this.identifierStore.getId(contextual);
        TransactionScopeData data = this.contextData.get();
        Object instance = data.getInstanceStore().get(id);
        if (instance == null) {
            instance = contextual.create(creationalContext);
            data.getCreationalContexts().put(id, creationalContext);
            data.getInstanceStore().put(id, instance);
        }
        return (T)instance;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public boolean isActive() {
        this.lazyInitialization();
        try {
            return this.userTransaction.isActive();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterCompletion(int status) {
        TransactionScopeData data = this.contextData.get();
        for (Map.Entry<String, Object> e : data.getInstanceStore().entrySet()) {
            Contextual<?> contextual = this.identifierStore.getContextual(e.getKey());
            CreationalContext<?> ctx = data.getCreationalContexts().get(e.getKey());
            contextual.destroy(e.getValue(), ctx);
            ctx.release();
        }
        this.contextData.remove();
    }

    public void beforeCompletion() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransactionScopeData {
        private final Map<String, Object> instanceStore = new HashMap<String, Object>();
        private final Map<String, CreationalContext<?>> creationalContexts = new HashMap();
        private boolean syncronisationRegistered;

        private TransactionScopeData() {
        }

        public boolean isSyncronisationRegistered() {
            return this.syncronisationRegistered;
        }

        public void setSyncronisationRegistered(boolean syncronisationRegistered) {
            this.syncronisationRegistered = syncronisationRegistered;
        }

        public Map<String, Object> getInstanceStore() {
            return this.instanceStore;
        }

        public Map<String, CreationalContext<?>> getCreationalContexts() {
            return this.creationalContexts;
        }
    }
}

