/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.seam.solder.literal.DefaultLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceResolver {
    private InstanceResolver() {
    }

    public static <T> Instance<T> getInstance(Class<T> type, BeanManager manager) {
        return InstanceResolver.getInstance(type, manager, new Annotation[]{DefaultLiteral.INSTANCE});
    }

    public static <T> Instance<T> getInstance(Class<T> type, BeanManager manager, Annotation ... qualifiers) {
        InstanceParamatizedTypeImpl<T> instanceType = new InstanceParamatizedTypeImpl<T>(type);
        Bean bean = manager.resolve(manager.getBeans(instanceType, qualifiers));
        CreationalContext ctx = manager.createCreationalContext((Contextual)bean);
        return (Instance)manager.getInjectableReference(new InstanceInjectionPoint<T>(type, qualifiers), ctx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceInjectionPoint<T>
    implements InjectionPoint {
        private final Class<T> type;
        private final Set<Annotation> qualifiers;

        public InstanceInjectionPoint(Class<T> type, Annotation ... quals) {
            this.type = type;
            this.qualifiers = new HashSet<Annotation>();
            for (Annotation a : quals) {
                this.qualifiers.add(a);
            }
        }

        public Annotated getAnnotated() {
            return null;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Type getType() {
            return new InstanceParamatizedTypeImpl<T>(this.type);
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceParamatizedTypeImpl<T>
    implements ParameterizedType {
        private final Class<T> type;

        public InstanceParamatizedTypeImpl(Class<T> type) {
            this.type = type;
        }

        @Override
        public Type[] getActualTypeArguments() {
            Type[] ret = new Type[]{this.type};
            return ret;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return Instance.class;
        }
    }
}

