/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.util;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamingUtils {
    private static final Logger log = LoggerFactory.getLogger(NamingUtils.class);
    private static Hashtable initialContextProperties;
    private static InitialContext initialContext;

    public static InitialContext getInitialContext(Hashtable<String, String> props) throws NamingException {
        if (props == null) {
            // empty if block
        }
        props = new Hashtable();
        if (log.isDebugEnabled()) {
            log.debug("JNDI InitialContext properties:" + props);
        }
        try {
            return props.size() == 0 ? new InitialContext() : new InitialContext(props);
        }
        catch (NamingException e) {
            log.debug("Could not obtain initial context");
            throw e;
        }
    }

    public static InitialContext getInitialContext() throws NamingException {
        if (initialContext == null) {
            NamingUtils.initInitialContext();
        }
        return initialContext;
    }

    private static synchronized void initInitialContext() throws NamingException {
        if (initialContext == null) {
            initialContext = NamingUtils.getInitialContext(initialContextProperties);
        }
    }

    private NamingUtils() {
    }

    public static void setInitialContextProperties(Hashtable initialContextProperties) {
        NamingUtils.initialContextProperties = initialContextProperties;
        initialContext = null;
    }

    public static Hashtable getInitialContextProperties() {
        return initialContextProperties;
    }
}

