/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.logging.Logger;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceContextProxyHandler;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.SeamPersistenceProvider;
import org.jboss.seam.persistence.util.BeanManagerUtils;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.seam.transaction.literal.DefaultTransactionLiteral;

public class ManagedPersistenceContextProxyHandler
extends PersistenceContextProxyHandler
implements InvocationHandler,
Serializable,
Synchronization {
    private static final long serialVersionUID = -6539267789786229774L;
    private final EntityManager delegate;
    private final PersistenceContexts persistenceContexts;
    private final Set<Annotation> qualifiers;
    private final SeamPersistenceProvider provider;
    private final BeanManager beanManager;
    private boolean persistenceContextsTouched = false;
    private boolean closeOnTransactionCommit = false;
    private transient SeamTransaction seamTransaction;
    private transient boolean synchronizationRegistered;
    static final Logger log = Logger.getLogger(ManagedPersistenceContextProxyHandler.class);

    public ManagedPersistenceContextProxyHandler(EntityManager delegate, BeanManager beanManager, Set<Annotation> qualifiers, PersistenceContexts persistenceContexts, SeamPersistenceProvider provider) {
        super(delegate, beanManager);
        this.qualifiers = qualifiers;
        this.provider = provider;
        this.delegate = delegate;
        this.persistenceContexts = persistenceContexts;
        this.beanManager = beanManager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("changeFlushMode".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(FlushModeType.class)) {
            this.changeFushMode((FlushModeType)args[0]);
            return null;
        }
        if ("getBeanType".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return EntityManager.class;
        }
        if ("getQualifiers".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return Collections.unmodifiableSet(this.qualifiers);
        }
        if ("getProvider".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return this.provider;
        }
        if ("closeAfterTransaction".equals(method.getName()) && method.getParameterTypes().length == 0) {
            this.closeAfterTransaction();
            return null;
        }
        if ("getTransaction".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return super.invoke(proxy, method, args);
        }
        if (!"setFlushMode".equals(method.getName()) && !this.synchronizationRegistered) {
            this.joinTransaction();
        }
        this.touch((ManagedPersistenceContext)proxy);
        return super.invoke(proxy, method, args);
    }

    private void joinTransaction() throws SystemException {
        SeamTransaction transaction = this.getTransaction();
        if (transaction.isActive()) {
            this.synchronizationRegistered = true;
            transaction.enlist(this.delegate);
            try {
                transaction.registerSynchronization((Synchronization)this);
            }
            catch (Exception e) {
                this.synchronizationRegistered = false;
                throw new RuntimeException(e);
            }
        }
    }

    private void closeAfterTransaction() throws SystemException {
        SeamTransaction transaction = this.getTransaction();
        if (transaction.isActive()) {
            this.closeOnTransactionCommit = true;
        } else if (this.delegate.isOpen()) {
            this.delegate.close();
        }
    }

    private void changeFushMode(FlushModeType flushModeType) {
        this.provider.setFlushMode(this.delegate, flushModeType);
    }

    void touch(ManagedPersistenceContext delegate) {
        if (!this.persistenceContextsTouched) {
            try {
                this.persistenceContextsTouched = true;
                if (this.persistenceContexts != null) {
                    this.persistenceContexts.touch(delegate);
                }
            }
            catch (ContextNotActiveException e) {
                this.persistenceContextsTouched = false;
                log.debug((Object)("Not touching pc " + this + "as conversation scope not active"));
            }
        }
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered = false;
        if (this.closeOnTransactionCommit && this.delegate.isOpen()) {
            this.delegate.close();
        }
    }

    public void beforeCompletion() {
    }

    private SeamTransaction getTransaction() {
        if (this.seamTransaction == null) {
            this.seamTransaction = BeanManagerUtils.getContextualInstance(this.beanManager, SeamTransaction.class, new Annotation[]{DefaultTransactionLiteral.INSTANCE});
        }
        return this.seamTransaction;
    }
}

